<?php
//Llamada al modelo
require 'model/ads_model.php';

class ads_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_ads($name,$seccion,$link,$descripcion,$imagen,$status,$id){
	$per=new ads_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($descripcion) > 200 || empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío ni superar los 200 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($link, FILTER_VALIDATE_URL)) {
		$datos = array('msg' => 'Link invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->query_sections($seccion);
	if (count($valid) == 0) {
		$datos = array('msg' => '¡Error! Seccion no existe','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($imagen)) {
		$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
		if ($ext!=="png" && $ext!=="jpg" && $ext!=="jpeg") {
			$datos = array('msg' => 'Error formato de imagen.','status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($imagen['tmp_name']);
		if ($tamaño[0]> 5000 || $tamaño[1] > 5000 || $imagen['size'] > 1000000) {		
			$datos = array('msg' =>'Error, la imagen debe tener un ancho inferior a 5000px y una altura de 5000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_ads($id);
		if (!$valid) {
			$datos = array('msg' => 'ads no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de ads.
*
*Funcion para consultar ads registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_ads(){
	$per=new ads_model();
	$datos=$per->query_ads(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de secciones.
*
*Funcion para consultar secciones registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_sections(){
	$per=new ads_model();
	$datos=$per->query_sections(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar ads.
*
*Funcion para Registrar ads, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_ads(){
	$per=new ads_model();
	$name=$_POST['name'];
	$link=$_POST['link'];
	$seccion=$_POST['seccion'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_ads($name,$seccion,$link,$descripcion,$imagen,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_ads($name,$seccion,$link,$descripcion,$imagen,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de ads.
*
*Funcion para consultar ads registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de ads
*/
public function view_ads(){
	$var1=$_POST['id'];
	$per=new ads_model();
	$datos=$per->query_ads($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'ads no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar ads.
*
*Funcion para Registrar ads, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_ads(){
	$per=new ads_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$seccion=$_POST['seccion'];
	$link=$_POST['link'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_ads($name,$seccion,$link,$descripcion,$imagen,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_ads($name,$seccion,$link,$descripcion,$imagen,$status,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar ads.
*
*Funcion para eliminar ads, chequea si el ads existe si arroja true elimina el ads*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_ads(){
	$per=new ads_model();
	$data1=$_POST['id'];
	$valid=$per->check_ads($data1);
	if (!$valid) {
		$datos = array('msg' => 'Ads no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_ads($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>