<?php
//Llamada al modelo
require 'model/age_groups_model.php';

class age_groups_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_age_group($edad_d,$edad_h,$status,$id){
	$per=new age_groups_model();

	if (!is_numeric($edad_d) || $edad_d < 18) {
		$datos = array('msg' => 'Edad Inicial invalida','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_numeric($edad_h) || $edad_d > $edad_h) {
		$datos = array('msg' => 'Edad Final invalida','status' => false ,'code' => 400);
		return $datos;
	}
	
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_age_group($id);
		if (!$valid) {
			$datos = array('msg' => 'Grupo etario no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($edad_d,$edad_h,$id);
	if (!$valid) {
		$datos = array('msg' => 'Error! Grupo etario existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_age_groups(){
	$per=new age_groups_model();
	$datos=$per->query_age_groups(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_age_group(){
	$per=new age_groups_model();
	$edad_d=$_POST['edad_d'];
	$edad_h=$_POST['edad_h'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_age_group($edad_d,$edad_h,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_age_group($edad_d,$edad_h,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_age_group(){
	$var1=$_POST['id'];
	$per=new age_groups_model();
	$datos=$per->query_age_groups($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Grupo etario no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_age_group(){
	$per=new age_groups_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$edad_d=$_POST['edad_d'];
	$edad_h=$_POST['edad_h'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_age_group($edad_d,$edad_h,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_age_group($edad_d,$edad_h,$status,$user,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_age_group(){
	$per=new age_groups_model();
	$data1=$_POST['id'];
	$valid=$per->check_age_group($data1);
	if (!$valid) {
		$datos = array('msg' => 'Grupo etario no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_age_group($data1);
	$return = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	if (!$datos) {
		$return = array('msg' => 'Grupo etario tiene datis asociado, solo se puede desactivar','status' => false,'code' => 400);

	}
	return $return;
}

}
?>