<?php
//Llamada al modelo
require 'model/banners_model.php';

class banners_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_banner($name,$link,$descripcion,$imagen,$status,$id){
	$per=new banners_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($descripcion) > 200 || empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío ni superar los 200 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($link) > 50 || empty($link)) {
		$datos = array('msg' => 'Link no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($imagen)) {
		$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
		if ($ext!=="png" && $ext!=="jpg" && $ext!=="jpeg") {
			$datos = array('msg' => 'Error formato de imagen.','status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($imagen['tmp_name']);
		if ($tamaño[0]> 5000 || $tamaño[1] > 5000 || $imagen['size'] > 10000000) {		
			$datos = array('msg' =>'Error, la imagen debe tener un ancho inferior a 5000px y una altura de 5000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_banner($id);
		if (!$valid) {
			$datos = array('msg' => 'Banner no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de banners.
*
*Funcion para consultar banners registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_banners(){
	$per=new banners_model();
	$datos=$per->query_banners(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar banner.
*
*Funcion para Registrar banner, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_banner(){
	$per=new banners_model();
	$name=$_POST['name'];
	$link=$_POST['link'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_banner($name,$link,$descripcion,$imagen,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_banner($name,$link,$descripcion,$imagen,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de banners.
*
*Funcion para consultar banners registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de banners
*/
public function view_banner(){
	$var1=$_POST['id'];
	$per=new banners_model();
	$datos=$per->query_banners($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Banner no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar banners.
*
*Funcion para Registrar banner, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_banner(){
	$per=new banners_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$link=$_POST['link'];
	$descripcion=$_POST['descripcion'];
	$imagen=$_FILES['imagen'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_banner($name,$link,$descripcion,$imagen,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_banner($name,$link,$descripcion,$imagen,$status,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar banner.
*
*Funcion para eliminar banner, chequea si el banner existe si arroja true elimina el banner*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_banner(){
	$per=new banners_model();
	$data1=$_POST['id'];
	$valid=$per->check_banner($data1);
	if (!$valid) {
		$datos = array('msg' => 'Banner no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_banner($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>