<?php
//Llamada al modelo
require 'model/contracts_model.php';

class contracts_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_contract($name,$descripcion,$status,$id){
	$per=new contracts_model();
	if (strlen($name) > 100 || empty($name)) {
		$datos = array('msg' => 'El titulo no debe estar vacío ni exceder los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_contract($id);
		if (!$valid) {
			$datos = array('msg' => 'Contrato no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => 'Error! titulo existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de contratos.
*
*Funcion para consultar contratos registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_contracts(){
	$per=new contracts_model();
	$datos=$per->query_contracts(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar contrato.
*
*Funcion para Registrar contrato, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_contract(){
	$per=new contracts_model();
	$name=$_POST['title_contract'];
	$descripcion=$_POST['descripcion'];
	$status=$_POST['status'];

	$user=$_SESSION['bn_user_global_agencias'];
	$valid=$this->validate_contract($name,$descripcion,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_contract($name,$descripcion,$status,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de contratos.
*
*Funcion para consultar contratos registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de contratos
*/
public function view_contract(){
	$var1=$_POST['id'];
	$per=new contracts_model();
	$datos=$per->query_contracts($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Contrato no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar contratos.
*
*Funcion para Registrar contrato, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_contract(){
	$per=new contracts_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['title_contract'];
	$descripcion=$_POST['descripcion'];

	$user=$_SESSION['bn_user_global_agencias'];
	$valid=$this->validate_contract($name,$descripcion,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_contract($name,$descripcion,$status,$user,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar contrato.
*
*Funcion para eliminar contrato, chequea si el contrato existe si arroja true elimina el contrato*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_contract(){
	$per=new contracts_model();
	$data1=$_POST['id'];
	$valid=$per->check_contract($data1);
	if (!$valid) {
		$datos = array('msg' => 'Contrato no existe','status' => false,'code' => 400);
		return $datos;
	}
	$valid=$per->check_blog($data1);
	if (!$valid) {
		$datos = array('msg' => 'Contrato tiene blogs asociado, solo se puede desactivar','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_contract($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_file($opcion_file,$archivo){
	$per=new contracts_model();
	if ($opcion_file == "1") {
		$ext = pathinfo($archivo['name'], PATHINFO_EXTENSION);
		if ($ext !=="png") {
			$datos = array('msg' => 'Error formato de imagen debe ser '.$ext,'status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($archivo['tmp_name']);
		if ($tamaño[0]> 3000 || $tamaño[1] > 3000 || $archivo['size'] > 500000) {		
			$datos = array('msg' =>'Error, la imagen debe tener un ancho inferior a 3000px y una altura de 3000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}else{
		$ext = pathinfo($archivo['name'], PATHINFO_EXTENSION);
		if ($ext!=="pdf" ) {
			$datos = array('msg' => 'Error formato de documento debe ser pdf','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->check_file($opcion_file);
	if (!$valid) {
		$datos = array('msg' => 'Archivo ya fue registrado y validado por Bee insurance no puede ser editado','status' => false,'code' => 400);
		return $datos;
	}

	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de contratos.
*
*Funcion para consultar contratos registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_files(){
	$per=new contracts_model();
	$datos=$per->query_files();
	$decryp=new routehelper();

	if (empty($_SESSION['bn_user_global_agencias']) || is_null($_SESSION['bn_user_global_agencias'])) {
		$id=$_SESSION['bn_user_global_advisers']; 
		$perfil=$_SESSION['bn_perfil'];
		$id=$perfil.'/'.$id.'/contracts';
		$enlace=$decryp->encryptroute_adviser($id);
	}else{
		$id=$_SESSION['bn_user_global_agencias']; 
		$perfil=$_SESSION['bn_perfil'];
		$id=$perfil.'/'.$id.'/contracts';
		$enlace=$decryp->encryptroute_agencie($id);
	}

	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos,'enlace' => $enlace);
	return $datos1;
}


/**
* Registrar archivo.
*
*Funcion para Registrar archivo, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_file(){
	$per=new contracts_model();
	$opcion_file=$_POST['opcion_file'];
	$archivo=$_FILES['archivo'];

	$valid=$this->validate_file($opcion_file,$archivo);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_file($opcion_file,$archivo);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

}
?>