<?php
//Llamada al modelo
require 'model/coupons_model.php';
require 'model/insurances_model.php';

class coupons_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$id_insurance,$desde,$hasta,$id){
	$per=new coupons_model();
	$per1=new insurances_model();
	if (strlen($name_cupon) > 50 || empty($name_cupon)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni exceder los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($code_cupon) > 20 || empty($code_cupon)) {
		$datos = array('msg' => 'Codigo no debe estar vacío ni exceder los 20 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_numeric($monto_cupon) || empty($monto_cupon) || $monto_cupon < 1) {
		$datos = array('msg' => 'Monto invalido','status' => false ,'code' => 400);
		return $datos;

	}
	if (!is_null($tipo_cupon) && $tipo_cupon > 2) {
		$datos = array('msg' => 'Metodo invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if ($tipo_cupon == "1") {
		if ($monto_cupon > 100) {
			$datos = array('msg' => 'Error! % mayor a 100%','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($id_insurance)) {
		$valid=$per1->check_insurance($id_insurance);
		if (!$valid) {
			$datos = array('msg' => 'Formulario no existe','status' => false ,'code' => 400);
			return $datos;
		}}
		if (!is_null($id)) {
			$valid=$per->check_coupon($id);
			if (!$valid) {
				$datos = array('msg' => 'Cupon no existe','status' => false ,'code' => 400);
				return $datos;
			}
		}
		$valid=$per->check_code($code_cupon,$id_insurance,$id);
		if (!$valid) {
			$datos = array('msg' => 'Error! Codigo existe','status' => false ,'code' => 400);
			return $datos;
		}
		$valid=$per->validateDate($desde);
		$valid1=$per->validateDate($hasta);
		if (!$valid || !$valid1) {
			$datos = array('msg' => 'Fecha invalida','status' => false ,'code' => 400);
			return $datos;
		}
		if ($desde > $hasta) {
			$datos = array('msg' => 'Error Fecha desde no puede ser mayor a Fecha hasta','status' => false ,'code' => 400);
			return $datos;
		}
		$datos = array('msg' => 'GOOD','status' =>true);
		return $datos;

	}
/**
* Vista de formularios.
*
*Funcion para consultar formularios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de formularios
*/
public function query_coupons(){
	$var1=$_POST['id'];
	$per=new coupons_model();
	$datos=$per->query_coupons($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Formulario no posee cupones agregados','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Registrar precio.
*
*Funcion para Registrar precio, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_coupon(){
	$per=new coupons_model();
	$id=$_POST['id'];
	$name_cupon=$_POST['name_cupon'];
	$code_cupon=$_POST['code_cupon'];
	$tipo_cupon=$_POST['tipo_cupon'];
	$monto_cupon=$_POST['monto_cupon'];
	$desde=$_POST['desde'];
	$hasta=$_POST['hasta'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$id,$desde,$hasta,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$desde,$hasta,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Registrar precio.
*
*Funcion para Registrar precio, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_coupon(){
	$per=new coupons_model();
	$name_cupon=$_POST['name_cupon'];
	$code_cupon=$_POST['code_cupon'];
	$tipo_cupon=$_POST['tipo_cupon'];
	$monto_cupon=$_POST['monto_cupon'];
	$id=$_POST['id'];
	$id_insurance=$_POST['id_insurance'];
	$desde=$_POST['desde'];
	$hasta=$_POST['hasta'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$id_insurance,$desde,$hasta,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$desde,$hasta,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Elimimar precio.
*
*Funcion para eliminar precio, chequea si el precio existe si arroja true elimina el precio*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_coupon(){
	$per=new coupons_model();
	$data1=$_POST['id'];
	$valid=$per->check_coupon($data1);
	if (!$valid) {
		$datos = array('msg' => 'Cupon no existe','status' => false,'code' => 400);
		return $datos;
	}
	$opcion=1;
	$user=$_SESSION['bn_user_global'];

	/*$valid=$per->check_game($data1);
	if (!$valid) {
		$datos = array('msg' => 'Formulario tiene juego asociado, solo se puede desactivar','status' => false,'code' => 400);
		return $datos;
	}*/
	$datos=$per->delete_coupon($data1,$opcion,$user);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
}
?>