<?php
//Llamada al modelo
require 'model/downloadable_files_model.php';

class downloadable_files_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_downloadable_file($name,$opcion_file,$descripcion,$archivo,$status,$id){
	$per=new downloadable_files_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($descripcion) > 200 || empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío ni superar los 200 caracteres','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($archivo)) {
		$ext = pathinfo($archivo['name'], PATHINFO_EXTENSION);
		if ($ext!=="pdf") {
			$datos = array('msg' => 'Error formato de archivo PDF','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid=$per->check_downloadable_file($id,$opcion_file);
		if (!$valid) {
			$datos = array('msg' => 'Archivo no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id,$opcion_file);
	if (!$valid) {
		$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de Archivos.
*
*Funcion para consultar Archivos registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_downloadable_files(){
	$per=new downloadable_files_model();
	$datos=$per->query_downloadable_files(NULL,1);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_downloadable_file(){
	$per=new downloadable_files_model();
	$name=$_POST['name'];
	$descripcion=$_POST['descripcion'];
	$archivo=$_FILES['archivo'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$opcion_file=$_POST['opcion_file'];

	$valid=$this->validate_downloadable_file($name,$opcion_file,$descripcion,$archivo,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_downloadable_file($name,$opcion_file,$descripcion,$archivo,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de Archivos.
*
*Funcion para consultar Archivos registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de Archivos
*/
public function view_downloadable_file(){
	$var1=$_POST['id'];
	$opcion_file=$_POST['opcion_file'];

	$per=new downloadable_files_model();
	$datos=$per->query_downloadable_files($var1,$opcion_file);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Archivo no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar Archivos.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_downloadable_file(){
	$per=new downloadable_files_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$descripcion=$_POST['descripcion'];
	$archivo=$_FILES['archivo'];
	$user=$_SESSION['bn_user_global'];
	$opcion_file=$_POST['opcion_file'];

	$valid=$this->validate_downloadable_file($name,$opcion_file,$descripcion,$archivo,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_downloadable_file($name,$descripcion,$archivo,$status,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_downloadable_file(){
	$per=new downloadable_files_model();
	$data1=$_POST['id'];
	$opcion_file=$_POST['opcion_file'];

	$valid=$per->check_downloadable_file($data1,$opcion_file);
	if (!$valid) {
		$datos = array('msg' => 'Archivo no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_downloadable_file($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => 'Error al eliminar archivo tiene productos asociados','status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

/**
* Consulta de Archivos de agentes.
*
*Funcion para consultar Archivos registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_downloadable_files_n(){
	$per=new downloadable_files_model();
	$datos=$per->query_downloadable_files(NULL,2);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}


}
?>