<?php
//Llamada al modelo
require 'model/insurances_model.php';

class insurances_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_insurance($name,$title_pdf,$descripcion,$declaracion_s,$status,$id){
	$per=new insurances_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni exceder los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}

	if (strlen($title_pdf) > 100 || empty($title_pdf)) {
		$datos = array('msg' => 'El titulo pdf no debe estar vacío ni exceder los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}

	if (strlen($descripcion) > 200 || empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío ni exceder los 200 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_array($declaracion_s) || count($declaracion_s) < 1) {
		$datos = array('msg' => 'Declaracion de riesgo no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;

	}
	/*if (!is_array($declaracion_p) || count($declaracion_p) < 1) {
		$datos = array('msg' => 'Declaracion de patologia y medicacion no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}*/
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($declaracion_s as $value) {
		$valid=$per->query_declaration_health($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Declaracion de riesgo no existe','status' => false ,'code' => 400);
			return $datos;
		}}
		/*foreach ($declaracion_p as $value1) {
			$valid1=$per->query_declaration_pathology($value1);
			if (count($valid1) == 0) {
				$datos = array('msg' => 'Error! Declaracion de patologia no existe','status' => false ,'code' => 400);
				return $datos;
			}}*/

			if (!is_null($id)) {
				$valid=$per->check_insurance($id);
				if (!$valid) {
					$datos = array('msg' => 'Formulario no existe','status' => false ,'code' => 400);
					return $datos;
				}
			}
			$valid=$per->check_name($name,$id);
			if (!$valid) {
				$datos = array('msg' => 'Error! Nombre existe','status' => false ,'code' => 400);
				return $datos;
			}
			$datos = array('msg' => 'GOOD','status' =>true);
			return $datos;
		}

/**
* Consulta de formularios.
*
*Funcion para consultar formularios registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_insurances(){
	$per=new insurances_model();
	$datos=$per->query_insurances(NULL);
	$decryp=new routehelper();
	foreach ($datos as &$value) {
		$act=$value['id'].'/'.$value['name'];
		$act=$decryp->encryptroute($act);
		$value['encrypt']=$act;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de declaracion de salud.
*
*Funcion para consultar declaracion de salud registrados *
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_declaration_health(){
	$per=new insurances_model();
	$datos=$per->query_declaration_health(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de declaracion de patologia.
*
*Funcion para consultar declaracion de patologia registrados *
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_declaration_pathology(){
	$per=new insurances_model();
	$datos=$per->query_declaration_pathology(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar formulario.
*
*Funcion para Registrar formulario, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_insurance(){
	$per=new insurances_model();
	$name=$_POST['name'];
	$title_pdf=$_POST['title_pdf'];
	$descripcion=$_POST['descripcion'];
	$declaracion_s=$_POST['declaracion_s'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_insurance($name,$title_pdf,$descripcion,$declaracion_s,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_insurance($name,$title_pdf,$descripcion,$declaracion_s,$status,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de formularios.
*
*Funcion para consultar formularios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de formularios
*/
public function view_insurance(){
	$var1=$_POST['id'];
	$per=new insurances_model();
	$datos=$per->query_insurances($var1);
	if (count($datos) > 0) {
		$datos1=$per->insurances_declaration_health($var1,2);
		//$datos2=$per->insurances_declaration_pathology($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'salud' => $datos1,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Formulario no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar formularios.
*
*Funcion para Registrar formulario, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_insurance(){
	$per=new insurances_model();
	$id=$_POST['id'];
	$descripcion=$_POST['descripcion'];
	$declaracion_s=$_POST['declaracion_s'];
	$name=$_POST['name'];
	$title_pdf=$_POST['title_pdf'];
	$status=$_POST['status'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_insurance($name,$title_pdf,$descripcion,$declaracion_s,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$declaracion_s1=$per->insurances_declaration_health($id,1);
		$declaracion_s1=(count($declaracion_s1) == 0)? [] : $declaracion_s1;
		$agregar_s = array_diff($declaracion_s, $declaracion_s1);
		$eliminar_s = array_diff($declaracion_s1,$declaracion_s);
		/*$declaracion_p1=$per->insurances_declaration_pathology($id,1);
		$declaracion_p1=(count($declaracion_p1) == 0)? [] : $declaracion_p1;
		$agregar_p = array_diff($declaracion_p, $declaracion_p1);
		$eliminar_p = array_diff($declaracion_p1,$declaracion_p);*/
		$datos=$per->edit_insurance($name,$title_pdf,$descripcion,$agregar_s,$eliminar_s,$status,$user,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201,'d' => $eliminar_s);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400,'d' => $eliminar_s);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar formulario.
*
*Funcion para eliminar formulario, chequea si el formulario existe si arroja true elimina el formulario*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_insurance(){
	$per=new insurances_model();
	$data1=$_POST['id'];
	$valid=$per->check_insurance($data1);
	if (!$valid) {
		$datos = array('msg' => 'Formulario no existe','status' => false,'code' => 400);
		return $datos;
	}
	/*$valid=$per->check_game($data1);
	if (!$valid) {
		$datos = array('msg' => 'Formulario tiene juego asociado, solo se puede desactivar','status' => false,'code' => 400);
		return $datos;
	}*/
	$datos=$per->delete_insurance($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>