<?php
//Llamada al modelo
require 'model/issue_model.php';

class issue_controller
{
/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_issue_advisers(){
	$per=new issue_model();
	$decryp=new routehelper();
	$asesor=$_SESSION['bn_user_global_advisers'];
	$datos=$per->query_issue_advisers($asesor);
	foreach ($datos as &$value) {
		$producto=$value['producto_id'];
		$total=$value['totalpago'];
		$comision=$per->query_comision($asesor,$producto);
		$suma=($total*$comision)/100;
		$suma=number_format($suma,2,".","");
		$value['comision']='$'.$suma;
		$id='6/'.$value['id'].'/reports_insurance';
		$id=$decryp->encryptroute_adviser($id);
		$value['id']=$id;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_product_advisers(){
	$asesor=$_SESSION['bn_user_global_advisers'];
	$per=new issue_model();
	$datos=$per->query_product_advisers($asesor);
	foreach ($datos as &$value) {
		$value['asesor']=$_SESSION['bn_verify_global_advisers'];
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de agencias.
*
*Funcion para consultar agencias registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_issue_agencies(){
	$per=new issue_model();
	$decryp=new routehelper();
	$agencia=$_SESSION['bn_user_global_agencias'];
	$datos=$per->query_issue_agencies($agencia);
	foreach ($datos as &$value) {
		$producto=$value['producto_id'];
		$total=$value['totalpago'];
		$comision=$per->query_comision_agencies($agencia,$producto);
		$suma=($total*$comision)/100;
		$suma=number_format($suma,2,".","");
		$value['comision']='$'.$suma;
		$perfil=$_SESSION['bn_perfil'];
		$id=$perfil.'/'.$value['id'].'/reports_insurance';
		$id=$decryp->encryptroute_agencie($id);
		$value['id']=$id;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_product_agencies(){
	$agencia=$_SESSION['bn_user_global_agencias'];
	$per=new issue_model();
	$datos=$per->query_product_agencies($agencia);
	foreach ($datos as &$value) {
		$value['agencia']=$_SESSION['bn_verify_global_agencias'];
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_issue_general(){
	$per=new issue_model();
	$decryp=new routehelper();
	$datos=$per->query_issue_general(NULL);
	foreach ($datos as &$value) {
		$id=$decryp->encryptroute_agencie($value['id']);
		$archivo='3/'.$value['id'].'/reports_insurance';
		$archivo=$decryp->encryptroute_agencie($archivo);
		$value['id']=$id;	
		$value['archivo']=$archivo;	
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_issue_detail(){
	$per=new issue_model();
	$decryp=new routehelper();
	$token=$_POST['token'];
	$token=$decryp->decryptroute($token);
	$token=explode('/', $token);
	$datos=$per->query_issue_detail($token[1]);
	foreach ($datos as &$value) {
		$archivo='3/'.$value['id'].'/reports_insurance';
		$archivo=$decryp->encryptroute_agencie($archivo);
		$cobertura=number_format($value['cobertura'],2,',','.');

		$subtotal=number_format($value['subtotal'],2,',','.');
		$monto_cupon=number_format($value['monto_cupon'],2,',','.');
		$descuento=number_format($value['descuento'],2,',','.');

		$total=number_format($value['total'],2,',','.');

		$value['subtotal']=$subtotal;
		$value['monto_cupon']=$monto_cupon;
		$value['descuento']=$descuento;

		$value['total']=$total;

		$value['cobertura']=$cobertura;
		$value['archivo']=$archivo;

	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_issue_total(){
	$per=new issue_model();
	$fecha=$_POST['fecha'];
	if (!empty($fecha)) {
	$fecha = explode("-", $fecha);
	$fechai = date("Y-m-d", strtotime($fecha[0]));
	$fechaf = date("Y-m-d", strtotime($fecha[1]));
	$date1=date_create($fechai);
	$date2 = date_create($fechaf);
	$diff = $date1->diff($date2);
	$diff= $diff->format('%R%a');
	$diff = substr($diff, 0,1);
	if($diff == "-"){
		$datos = array('msg' => 'Error Date','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->query_issue_total($fechai,$fechaf);
    }else{
	$datos=$per->query_issue_total(NULL,NULL);
    }
	foreach ($datos as &$value) {
		$suma_asegurada=number_format($value['suma_asegurada'],2,',','.');
		$subtotal=number_format($value['subtotal'],2,',','.');
		$monto_cupon=number_format($value['monto_cupon'],2,',','.');
		$descuento=number_format($value['descuento'],2,',','.');
		$total=number_format($value['total'],2,'.','');


		$comision_sa=$per->query_comision_agencies(1,$value['producto']);
		$value['comision_sa']=$comision_sa;

		switch ($value['perfil']) {
			case 'Agencia':
			$value['usuario_agencia']=$value['nombre_agencia'];
			$value['code_agencia']=$value['code_age'];
			if ($value['level'] == "1") {
				$restacomision=$comision_sa-$comision_am;
				$comision_am=$per->query_comision_agencies($value['id_agency'],$value['producto']);
				$suma=($value['total']*$restacomision)/100;
				$mcomision_am=number_format($suma,2,".","");
				$value['mcomision_am']=$mcomision_am;
				$value['comision_am']=$comision_am;
				$value['comision_ag']='0.00';
				$value['mcomision_ag']='0.00';
			}else{
				$comision_ag=$per->query_comision_agencies($value['id_agency'],$value['producto']);
				$value['comision_ag']=$comision_ag;
				$padre=$per->query_fhater($value['id_agency'],2);
				if ($padre[0]['level'] == "1") {
					$comision_am=$per->query_comision_agencies($padre[0]['agencia'],$value['producto']);
					$restacomision=$comision_sa-$comision_am;

					$suma=($value['total']*$restacomision)/100;
					$mcomision_am=number_format($suma,2,".","");
					$value['mcomision_am']=$mcomision_am;
					$value['comision_am']=$comision_am;

					$restacomision=$comision_am-$comision_ag;
					$suma=($value['total']*$restacomision)/100;
					$mcomision_ag=number_format($suma,2,".","");
					$value['mcomision_ag']=$mcomision_ag;
				}else{
					$value['comision_am']='0.00';
					$value['mcomision_am']='0.00';
				}
			}
			$value['comision_as']='0.00';
			$value['mcomision_as']='0.00';
			break;
			case 'Asesor':
			$value['usuario_agencia']=$value['nombre_asesor'];
			$value['code_agencia']=$value['code_ase'];
			$comision_as=$per->query_comision($value['id_adviser'],$value['producto']);
			$value['comision_as']=$comision_as;
			$padre=$per->query_fhater($value['id_adviser'],1);
			if ($padre[0]['level'] == "1") {
				$comision_am=$per->query_comision_agencies($padre[0]['agencia'],$value['producto']);
				$restacomision=$comision_sa-$comision_am;
				$suma=($value['total']*$restacomision)/100;
				$mcomision_am=number_format($suma,2,".","");
				$value['mcomision_am']=$mcomision_am;
				$value['comision_am']=$comision_am;
				$value['comision_ag']='0.00';
				$value['mcomision_ag']='0.00';


				$restacomision=$comision_am-$comision_as;
				$suma=($value['total']*$restacomision)/100;
				$mcomision_as=number_format($suma,2,".","");
				$value['mcomision_as']=$mcomision_as;

			}elseif ($padre[0]['level'] == "2") {
				$comision_ag=$per->query_comision_agencies($padre[0]['agencia'],$value['producto']);
				$value['comision_ag']=$comision_ag;
				$padre_am=$per->query_fhater($padre[0]['agencia'],2);
				if ($padre_am[0]['level'] == "1") {
					$comision_am=$per->query_comision_agencies($padre_am[0]['agencia'],$value['producto']);
					$restacomision=$comision_sa-$comision_am;
					$suma=($value['total']*$restacomision)/100;
					$mcomision_am=number_format($suma,2,".","");
					$value['mcomision_am']=$mcomision_am;
					$value['comision_am']=$comision_am;

					$restacomision=$comision_am-$comision_ag;
					$suma=($value['total']*$restacomision)/100;
					$mcomision_ag=number_format($suma,2,".","");
					$value['mcomision_ag']=$mcomision_ag;

				}else{
					$value['comision_am']='0.00';
					$value['mcomision_am']='0.00';
				}

				$restacomision=$comision_ag-$comision_as;
				$suma=($value['total']*$restacomision)/100;
				$mcomision_as=number_format($suma,2,".","");
				$value['mcomision_as']=$mcomision_as;


			}else{
				$restacomision=$comision_sa-$comision_as;
				$suma=($value['total']*$restacomision)/100;
				$mcomision_as=number_format($suma,2,".","");
				$value['mcomision_as']=$mcomision_as;
				$value['comision_am']='0.00';
				$value['mcomision_am']='0.00';
				$value['comision_ag']='0.00';
				$value['mcomision_ag']='0.00';
			}
			break;
			case 'Agencia IBO':
			$value['usuario_agencia']=$value['agencia_ibo'];
			$value['code_agencia']=$value['ibo'];
			$value['comision_am']='0.00';
			$value['mcomision_am']='0.00';
			$value['comision_ag']='0.00';
			$value['mcomision_ag']='0.00';
			$value['comision_as']='0.00';
			$value['mcomision_as']='0.00';
			break;
			default:
			$value['usuario_agencia']="Web";
			$value['code_agencia']="N/A";
			$value['comision_am']='0.00';
			$value['mcomision_am']='0.00';
			$value['comision_ag']='0.00';
			$value['mcomision_ag']='0.00';
			$value['comision_as']='0.00';
			$value['mcomision_as']='0.00';
			break;
		}
		//$totalc=$value['mcomision_sa']+$value['mcomision_am']+$value['mcomision_ag']+$value['mcomision_as'];

        $suma_c=$value['mcomision_as'] + $value['mcomision_am'] + $value['mcomision_ag']; 
		$suma=($value['total']*$comision_sa)/100;
		$mcomision_sa=number_format($suma,2,".","");
		$suma_c=$mcomision_sa-$suma_c;
		$suma_c=number_format($suma_c,2,".","");
		$value['mcomision_sa']=$suma_c;


		$totalc=$mcomision_sa;

		$totalc=number_format($totalc,2,".","");
		$value['totalc']=$totalc;



		$value['subtotal']=$subtotal;
		$value['monto_cupon']=$monto_cupon;
		$value['descuento']=$descuento;
		$value['total']=$total;
		$value['suma_asegurada']=$suma_asegurada;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}



}
?>