<?php
//Llamada al modelo
require 'model/kiosks_model.php';

class kiosks_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_kiosk($name,$productos,$imagen,$status,$id){
	$per=new kiosks_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni exceder los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_array($productos) || count($productos) < 1) {
		$datos = array('msg' => 'Producto no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($productos as $value) {
		$valid=$per->select_products($value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Producto no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($imagen)) {
		$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
		if ($ext!=="png" && $ext!=="jpg" && $ext!=="jpeg") {
			$datos = array('msg' => 'Error formato de imagen.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($id)) {
		$valid=$per->check_kiosk($id);
		if (!$valid) {
			$datos = array('msg' => 'Agencia ibo no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$valid=$per->check_name($name,$id);
	if (!$valid) {
		$datos = array('msg' => 'Error! Nombre existe','status' => false ,'code' => 400);
		return $datos;
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_kiosks(){
	$per=new kiosks_model();
	$datos=$per->query_kiosks(NULL);
	foreach ($datos as &$value) {
	$datos2=$per->check_products($value['id'],2);
	$value['productos']=(count($datos2) == 0) ? [] : $datos2;
    }
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de productos.
*
*Funcion para consultar productos registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function select_products(){
	$per=new kiosks_model();
	$datos=$per->select_products(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Generar token.
*
*Funcion para generar token para seccion de usuario*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function generation_pass(){
	$length = 15;
	$date=date('YmdHis');
	$llave=substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length); 

	return $llave.$date;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_kiosk(){
	$per=new kiosks_model();
	$name=$_POST['name'];
	$productos=$_POST['productos'];
	$imagen=$_FILES['imagen'];
	$status=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_kiosk($name,$productos,$imagen,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$token=$this->generation_pass();
		$datos=$per->register_kiosk($name,$productos,$imagen,$status,$user,$token);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_kiosk(){
	$var1=$_POST['id'];
	$per=new kiosks_model();
	$datos=$per->query_kiosks($var1);
	if (count($datos) > 0) {
	    $datos2=$per->check_products($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'productos' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Agencia ibo no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_kiosk(){
	$per=new kiosks_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$productos=$_POST['productos'];
	$imagen=$_FILES['imagen'];

	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_kiosk($name,$productos,$imagen,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$productos_s1=$per->check_products($id,1);
		$productos_s1=(count($productos_s1) == 0)? [] : $productos_s1;
		$agregar_s = array_diff($productos, $productos_s1);
		$eliminar_s = array_diff($productos_s1,$productos);
		$datos=$per->edit_kiosk($name,$status,$agregar_s,$eliminar_s,$imagen,$user,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_kiosk(){
	$per=new kiosks_model();
	$data1=$_POST['id'];
	$valid=$per->check_kiosk($data1);
	if (!$valid) {
		$datos = array('msg' => 'Agencia ibo no existe','status' => false,'code' => 400);
		return $datos;
	}
	$valid=$per->check_buy($data1);
	if (!$valid) {
		$datos = array('msg' => 'Agencia ibo tiene ventas asociada, solo se puede desactivar','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_kiosk($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

}
?>