<?php
//Llamada al modelo
require 'model/products_model.php';

class products_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$agencias_master,$superagencia,$asesores,$status,$id,$web){
	$per=new products_model();
	if (strlen($name) > 50 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni superar los 50 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (empty($descripcion)) {
		$datos = array('msg' => 'Descripcion no debe estar vacío','status' => false ,'code' => 400);
		return $datos;
	}
	if (empty($precio)) {
		$datos = array('msg' => 'Error! Campo precio','status' => false ,'code' => 400);
		return $datos;
	}
	/*if (!is_float($agencias_master) || !is_float($asesores) || !is_float($superagencia)) {
		$datos = array('msg' => 'Error! % Comision debe ser numerico','status' => false ,'code' => 400);
		return $datos;
	}*/
	if ($agencias_master > 100 || $asesores > 100 || $superagencia > 100 ) {
		$datos = array('msg' => 'Error! % Comision no debe ser mayor a 100','status' => false ,'code' => 400);
		return $datos;
	}
	if ($agencias_master >= $superagencia) {
		$datos = array('msg' => 'Error! % Comision de Agencia master no debe ser mayor o igual a Bee agency','status' => false ,'code' => 400);
		return $datos;
	}
	if ($asesores >= $agencias_master) {
		$datos = array('msg' => 'Error! % Comision de Agentes no debe ser mayor o igual a Agencias Master','status' => false ,'code' => 400);
		return $datos;
	}
	if (count($archivos) > 0) {
		if (!is_array($archivos)) {
			$datos = array('msg' => 'Archivo no debe estar vacío ','status' => false ,'code' => 400);
			return $datos;
		}
		foreach ($archivos as $value) {
			$valid=$per->query_downloadable_files($value);
			if (count($valid) == 0) {
				$datos = array('msg' => 'Error! Archivo no existe','status' => false ,'code' => 400);
				return $datos;
			}
		}}
		$valid=$per->query_insurances($formulario);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Formulario no existe','status' => false ,'code' => 400);
			return $datos;
		}
		if (!is_null($imagen)) {
			$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
			if ($ext!=="png" && $ext!=="jpg" && $ext!=="jpeg") {
				$datos = array('msg' => 'Error formato de imagen.','status' => false ,'code' => 400);
				return $datos;
			}
			$tamaño = getimagesize($imagen['tmp_name']);
			if ($tamaño[0]> 5000 || $tamaño[1] > 5000 || $imagen['size'] > 500000) {		
				$datos = array('msg' =>'Error, la imagen debe tener un ancho inferior a 5000px y una altura de 5000px.','status' => false ,'code' => 400);
				return $datos;
			}
		}
		if (!is_null($status) && $status > 2) {
			$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
			return $datos;
		}

		if (!is_numeric($web) && $web > 2) {
			$datos = array('msg' => 'Opcion web invalid','status' => false ,'code' => 400);
			return $datos;
		}

		if (!is_null($id)) {
			$valid=$per->check_product($id);
			if (!$valid) {
				$datos = array('msg' => 'Producto no existe','status' => false ,'code' => 400);
				return $datos;
			}
		}
		$valid=$per->check_name($name,$id);
		if (!$valid) {
			$datos = array('msg' => '¡Error! Nombre existe','status' => false ,'code' => 400);
			return $datos;
		}
		$valid=$per->check_insurances($formulario,$id);
		if (!$valid) {
			$datos = array('msg' => 'Formulario esta asociado a otro producto','status' => false ,'code' => 400);
			return $datos;
		}
		$datos = array('msg' => 'GOOD','status' =>true);
		return $datos;
	}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_products(){
	$per=new products_model();
	$datos=$per->query_products(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_insurances(){
	$per=new products_model();
	$datos=$per->query_insurances(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_downloadable_files(){
	$per=new products_model();
	$datos=$per->query_downloadable_files(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_product(){
	$per=new products_model();
	$name=$_POST['name'];
	$precio=(empty($_POST['precio']))? '0,00' : $_POST['precio'];
	$precio=str_replace('.','',$precio);
	$precio=str_replace(',','.', $precio);
	$descripcion=$_POST['descripcion'];
	$agencias_master=str_replace('.','',$_POST['agencias_master']);
	$agencias_master=str_replace(',','.', $agencias_master);
	$asesores=str_replace('.','',$_POST['asesores']);
	$asesores=str_replace(',','.', $asesores);
	$superagencia=str_replace('.','',$_POST['superagencia']);
	$superagencia=str_replace(',','.', $superagencia);
	$formulario=$_POST['formulario'];
	$archivos=$_POST['archivos'];
	$imagen=$_FILES['imagen'];
	$status=1;
	$web=$_POST['web'];

	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$agencias_master,$superagencia,$asesores,$status,NULL,$web);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$superagencia,$agencias_master,$asesores,$web,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_product(){
	$var1=$_POST['id'];
	$per=new products_model();
	$datos=$per->query_products($var1);
	if (count($datos) > 0) {
		$datos2=$per->check_archivos($var1,2);
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'archivos' => $datos2,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Producto no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_product(){
	$per=new products_model();
	$id=$_POST['id'];
	$status=$_POST['status'];
	$name=$_POST['name'];
	$descripcion=$_POST['descripcion'];
	$precio=(empty($_POST['precio']))? '0,00' : $_POST['precio'];
	$precio=str_replace('.','',$precio);
	$precio=str_replace(',','.', $precio);
	$imagen=$_FILES['imagen'];
	$formulario=$_POST['formulario'];
	$archivos=$_POST['archivos'];
	$agencias_master=str_replace('.','',$_POST['agencias_master']);
	$agencias_master=str_replace(',','.', $agencias_master);
	$asesores=str_replace('.','',$_POST['asesores']);
	$asesores=str_replace(',','.', $asesores);
	$superagencia=str_replace('.','',$_POST['superagencia']);
	$superagencia=str_replace(',','.', $superagencia);
	$web=$_POST['web'];

	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$agencias_master,$superagencia,$asesores,$status,$id,$web);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$status,$superagencia,$agencias_master,$asesores,$web,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

/**
* Elimimar empleado.
*
*Funcion para eliminar empleado, chequea si el empleado existe si arroja true elimina el empleado*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_product(){
	$per=new products_model();
	$data1=$_POST['id'];
	$valid=$per->check_product($data1);
	if (!$valid) {
		$datos = array('msg' => 'Producto no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_product($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}


}
?>