<?php
//Llamada al modelo
require 'model/quoters_model.php';

class quoters_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_quoter($name,$last_name,$email,$fecha_nac,$producto,$tarifas,$user){
	$per=new quoters_model();
	if (strlen($name) > 100 || empty($name)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni exceder los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (strlen($last_name) > 100 || empty($last_name)) {
		$datos = array('msg' => 'Apellidos no debe estar vacío ni exceder los 100 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->validateDate($fecha_nac);
	if (!$valid) {
		$datos = array('msg' => 'Fecha Nacimiento invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$cumpleanos = new DateTime($fecha_nac);
	$hoy = new DateTime();
	$annos = $hoy->diff($cumpleanos);
	$edad=$annos->y;
	if ($edad < 18) {
		$datos = array('msg' => 'El titular debe ser mayor a 18 años','status' => false ,'code' => 400);
		return $datos;
	}
	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email invalido','status' => false ,'code' => 400);
		return $datos;
	}
	$valid=$per->check_product($producto,$user);
	if (!$valid) {
		$datos = array('msg' => 'Error! Producto no existe','status' => false ,'code' => 400);
		return $datos;
	}
	if ($producto == "4") {
		$datos = array('msg' => 'Error! Producto Bee travel no se puede cotizar','status' => false ,'code' => 400);
		return $datos;
	}
	$coberturas=$per->query_price_product($producto);
	if (count($coberturas) == 0) {
		$datos = array('msg' => 'Error! Producto no posee coberturas agregadas','status' => false ,'code' => 400);
		return $datos;
	}

	$grupo=$per->age_group($edad);

	foreach ($tarifas as $value) {
		$valid=$per->sum_assured($producto,$grupo,0,$value);
		if (count($valid) == 0) {
			$datos = array('msg' => 'Error! Tarifa no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}


	$datos = array('msg' => 'GOOD','status' =>true,'edad' =>$edad);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_quoters(){
	$per=new quoters_model();
	$datos=$per->query_quoters(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function query_price_product(){
	$var1=$_POST['id'];
	$per=new quoters_model();
	$datos=$per->query_price_product($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Producto no posee precios agregados','status' => false,'code' => 400);
	}
	return $datos1;
}

/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function query_price(){
	$per=new quoters_model();
	$fecha_nac=$_POST['fecha_nac'];
	$producto=$_POST['producto'];
	$pais=$_POST['pais'];
	$fuma=$_POST['fuma'];

	$valid=$per->validateDate($fecha_nac);
	if (!$valid) {
		$datos = array('msg' => 'Fecha Nacimiento invalida','status' => false ,'code' => 400);
		return $datos;
	}
	$cumpleanos = new DateTime($fecha_nac);
	$hoy = new DateTime();
	$annos = $hoy->diff($cumpleanos);
	$edad=$annos->y;
	if ($edad < 18) {
		$datos = array('msg' => 'El titular debe ser mayor a 18 años','status' => false ,'code' => 400);
		return $datos;
	}
	//$edad=$valid['edad'];
	$grupo=$per->age_group($edad);
	$datos=$per->sum_assured($producto,$grupo,0,NULL);
	if (count($datos) > 0) {
		foreach ($datos as &$value) {
			$plan=$value['id'];
			$precios=$per->query_price($plan,$edad,$pais);
			if ($precios['status']) {
				if ($fuma == "1") {
					$smoker_taxes=$per->smoker_taxes($producto,$precios['datos']);
					$precios['datos']=$smoker_taxes['total'];
				}
				$precio=$precios['datos'];
			}else{
				$precio='No posee tarifas para esta suma asegurada';
			}
			$value['pago']=$precio;
		}		
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Producto no posee precios agregados','status' => false,'code' => 400,'grupo'=>$grupo);
	}
	return $datos1;
}
/**
* Generar token.
*
*Funcion para generar token para seccion de usuario*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function generation_body($names,$coberturas,$edad,$producto_name,$producto,$fecha_nac){
	$fecha=date('Y-m-d');
	$encabezado='<center><div style="width:100%;"><img src="https://admin.bee-insurance.com/dist/img/logo2.png"  style="height: 120px;"></div><br><h1 style="color:#000">Cotización Bee Insurance '.$fecha.'</h1></center>';

	//$body='<h3>Hola '.$name.' reciba un cordial saludo, para nosotros es un placer saludarte.</h3><p>Hemos generado una cotizacion para el producto <a href="https://bee-insurance.com/bee-details.php?idpr='.$producto.'">'.$producto_name.'</a></p><p> A continuacion le presentamos toda la informacion correspondiente:</p>';

	$body='<h3>Hola '.$names.' reciba un cordial saludo, para nosotros es un placer saludarte.</h3><p>Hemos generado una cotizacion para el producto '.$producto_name.'</p><p> A continuacion le presentamos toda la informacion correspondiente:</p>';


	$body.='<b>Fecha de nacimiento: '.$fecha_nac.'</b><br><b>Edad actual: '.$edad.'</b><br>';
    
    if ($producto == "3" || $producto == "8") {
	$body.='<h1 style="color:#407bb8;">Sumas aseguradas para '.$producto_name.'</h1>';
    }else{
	$body.='<h1 style="color:#407bb8;">Sumas aseguradas para '.$producto_name.'</h1> <a href="https://bee-insurance.com/detalles_condiciones.php?product='.$producto.'" ><p>Detalles de sumas asegurada y condiciones</p></a>';
    }

	foreach ($coberturas as $value) {
		$plan=$value->precio;
		$monto=$value->pago;
		$body.='<p><b>Suma asegurada: USD </b>'.$plan.' <b> Precio: USD </b>'.$monto.'</p>';
	}
	$footer='<center><div style="text-align: center;">WhatsApp: <a href="https://api.whatsapp.com/send?phone=17867825313" > +17867825313 </a> | email: info@bee-insurance.com | web: www.bee-insurance.com</div></center>';  
	$html=$encabezado.$body.'<hr>'.$footer;

	return $html;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_quoter(){
	$per=new quoters_model();
	$name=$_POST['name'];
	$last_name=$_POST['last_name'];
	$email=$_POST['email'];
	$fecha_nac=$_POST['fecha_nac'];
	$producto=$_POST['producto'];
	$tarifas=$_POST['tarifas'];
	$pais=$_POST['pais'];
	$fuma=$_POST['fuma'];

	$perfil=$_SESSION['bn_perfil'];
	$user=($perfil == "6") ? $_SESSION['bn_user_global_advisers'] : $_SESSION['bn_user_global_agencias'];

	$valid=$this->validate_quoter($name,$last_name,$email,$fecha_nac,$producto,$tarifas,$user);
	if (!$valid['status']) {
		return $valid;
	}else{
		$producto_name=$per->query_product($producto);
		$edad=$valid['edad'];
		$grupo=$per->age_group($edad);
		$coberturas[] =new stdClass;
		$y=0;

		foreach ($tarifas as $value) {
			$sumas=$per->sum_assured($producto,$grupo,0,$value);
			$cobertura=number_format($sumas[0]['precio'],2,',','.');

			$precios=$per->query_price($value,$edad,$pais);
			if ($precios['status']) {
				if ($fuma == "1") {
					$smoker_taxes=$per->smoker_taxes($producto,$precios['datos']);
					$precios['datos']=$smoker_taxes['total'];
				}
				$precio=number_format($precios['datos'],2,',','.');
			}else{
				$precio='No posee tarifas para esta suma asegurada';
			}

			$coberturas[$y]->precio = $cobertura;
			$coberturas[$y]->pago = $precio;
			$y++;
		}
        $names=$name.' '.$last_name;
		$html=$this->generation_body($names,$coberturas,$edad,$producto_name,$producto,$fecha_nac);

		$datos=$per->register_quoter($pais,$fuma,$producto,$name,$last_name,$email,$fecha_nac,$user,$html);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_quoters_detail(){
	$per=new quoters_model();
	$id=$_POST['id'];
	$datos=$per->query_quoters_detail($id);
    $perfil=$_SESSION['bn_perfil'];
    $user=($perfil == "6") ? $_SESSION['bn_verify_global_advisers'] : $_SESSION['bn_verify_global_agencias'];
    
    //$datos['user']=$user;
	foreach ($datos as &$value) {
    $value['user']=$user;
	}
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}

}
?>