<?php
//Llamada al modelo
require 'model/smoker_taxes_model.php';

class smoker_taxes_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_smoker_tax($tipo,$monto,$status,$id){
	
	if (!is_null($tipo) && $tipo > 2) {
		$datos = array('msg' => 'Metodo invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($status) && $status > 2) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_numeric($monto)) {
		$datos = array('msg' => 'Error, Monto invalido','status' => false ,'code' => 400);
		return $datos;
	}

	if ($tipo == "1" && $monto > 100) {
		$datos = array('msg' => 'Error, % Debe ser de 0 a 100','status' => false ,'code' => 400);
		return $datos;
	}

	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}
/**
* Registrar empleado.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_smoker_tax(){
	$per=new smoker_taxes_model();
	$id=$_POST['id'];
	$tipo=$_POST['tipo'];
	$monto=$_POST['monto'];
	$status=$_POST['status'];

	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_smoker_tax($tipo,$monto,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos_smoker=$per->query_smoker_taxes($id);
		if (count($datos_smoker) > 0) {
		$datos=$per->edit_smoker_tax($tipo,$monto,$status,$id,$user);
		}else{
		$datos=$per->register_smoker_tax($tipo,$monto,$status,$id,$user);
		}
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de empleados.
*
*Funcion para consultar empleados registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de empleados
*/
public function view_smoker_tax(){
	$var1=$_POST['id'];
	$per=new smoker_taxes_model();
	$datos=$per->query_smoker_taxes($var1);
	$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);

	return $datos1;
}


}
?>