<?php
//Llamada al modelo
require 'model/users_model.php';

class users_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true]   
*/
public function validate_user($perfil,$usuario,$nombre,$clave_incial,$status,$id,$email){
	$per=new users_model();
	if (strlen($nombre) > 40 || empty($nombre)) {
		$datos = array('msg' => 'El nombre no debe estar vacío ni exceder los 40 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	$usuario=trim($usuario);
	if (strlen($usuario) > 30 || empty($usuario)) {
		$datos = array('msg' => 'El Username no debe estar vacío ni exceder los 30 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($clave_incial)) {
		if (strlen($clave_incial) < 8 || empty($clave_incial)) {
			$datos = array('msg' => 'La contraseña debe contener un mínimo de 8 caracteres','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		$datos = array('msg' => 'Email invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if ($status > 2 || !is_numeric($status)) {
		$datos = array('msg' => 'Status invalid','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_numeric($perfil)) {
		$datos = array('msg' => 'Perfil invalido','status' => false ,'code' => 400);
		return $datos;
	}

	$valid2=$per->check_email($email,$id);
	if (!$valid2) {
		$datos = array('msg' => 'Error! Email existe','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_null($id)) {
		$valid3=$per->check_user($id);
		if (!$valid3) {
			$datos = array('msg' => 'Usuario no existe','status' => false ,'code' => 400);
			return $datos;
		}
		$usuario=trim($usuario);
		$valid2=$per->check_name($usuario,$id);
		if (!$valid2) {
			$datos = array('msg' => 'Error! Username existe','status' => false ,'code' => 400);
			return $datos;
		}
	}else{
		$usuario=trim($usuario);
		$valid2=$per->check_name($usuario,NULL);
		if (!$valid2) {
			$datos = array('msg' => 'Error! Username existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$datos = array('msg' => 'GOOD','status' =>'T');
	return $datos;
}
/**
* Consulta de usuarios.
*
*Funcion para consultar usuarios registrados para llenar tabla*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_users(){
	$per=new users_model();
	$datos=$per->query_users(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Registrar Usuario.
*
*Funcion para Registrar usuario, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function register_user(){
	$per=new users_model();
	$perfil=$_POST['perfil'];
	$usuario=$_POST['usuario'];
	$nombre=$_POST['nombre'];
	$clave=$_POST['clave'];
	$clave_incial=$clave;
	$opciones = [
	'cost' => 12,
	];
	$email=$_POST['email'];

	$clave=password_hash($clave_incial, PASSWORD_BCRYPT, $opciones);
	$status=1;
	$valid=$this->validate_user($perfil,$usuario,$nombre,$clave_incial,$status,NULL,$email);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_user($perfil,$usuario,$nombre,$clave,$status,$email);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de Usuario.
*
*Funcion para consultar usuario registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id del usuario
*/
public function view_user(){
	$var1=$_POST['data1'];
	$per=new users_model();
	$datos=$per->query_users($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Usuario no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar de Usuario.
*
*Funcion para editar usuario, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function edit_user(){
	$per=new users_model();
	$perfil=$_POST['perfil'];
	$usuario=$_POST['usuario'];
	$nombre=$_POST['nombre'];	
	$status=$_POST['status'];
	$id=$_POST['id'];
	$email=$_POST['email'];

	$valid=$this->validate_user($perfil,$usuario,$nombre,NULL,$status,$id,$email);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_user($perfil,$usuario,$nombre,$status,$id,$email);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 200);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Editar Contraseña de Usuario.
*
*Funcion para editar contraseña de usuario, encriptandola*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST String $clave_incial clave para modificar,Int $id id del usuario
*/
public function edit_password(){
	$per=new users_model();
	$clave_incial=$_POST['clave'];
	$opciones = [
	'cost' => 12,
	];
	$clave=password_hash($clave_incial, PASSWORD_BCRYPT, $opciones);
	$id=$_POST['id'];
	$datos=$per->query_users($id);
	if (count($datos) == 0) {
		return $datos1 = array('msg' => 'Usuario no existe','status' => false ,'code' => 400);
	}else if (strlen($clave_incial) < 8 || empty($clave_incial)) {
		$datos = array('msg' => 'La contraseña debe contener un mínimo de 8 caracteres','status' => false ,'code' => 400);
		return $datos;
	}else{
		$datos=$per->edit_password($clave,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Elimimar Usuario.
*
*Funcion para eliminar usuario, chequea si el usuario existe si arroja true elimina el usuario*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST Int $data1 id del usuario
*/
public function delete_user(){
	$per=new users_model();
	$data1=$_POST['id'];
	$valid3=$per->check_user($data1);
	if (!$valid3 || $data1=="1") {
		$datos = array('msg' => 'Usuario no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_user($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;

}
}
?>