  <script>

  	$(function () {
//ready
const Toast = Swal.mixin({
	toast: true,
	position: 'top-end',
	showConfirmButton: false,
	timer: 3000
});
const formatterDolar = new Intl.NumberFormat('es-VE', {
 style: 'currency',
 currency: 'BSF'
});
$(document).ready(function(e) {

});
var wp_table = $("#list_agencies_masters").DataTable({
  responsive: {
    details: {
      type: 'column'
    }
  },
  columnDefs: [ {
    className: 'control',
    orderable: false,
    targets:   0
  } ],
  order: [ 2, 'asc' ],
  autoWidth: true,
  bProcessing: false,
  bServerSide: false,
  bInfo: false,
  columns: [
  { data: 'id' , render: function(data, type, row){
    return cel(data, row.id);
  }},
  { data: 'name'},
  { data: 'comision'},

  { data: 'id', render: function(data, type, row){
    return actions(data,row.image,row.license);
  }},
  ],
});
//Funcion para consultar datos de usarios y llenar tabla//
function dataTable_init() {
  data = {'option':'<?php echo $decryp->encryptroute_agencie('view/commissions_reports/query_agencies_masters')?>'};
  $.post('<?php echo $url_admin;?>core/process2.php', data)
  .done(function(resp){
   wp_table = $("#list_agencies_masters").DataTable();
   wp_table.clear();
   $.each(resp.datos, function (k, v) {
    wp_table.row.add(v);
  });
   wp_table.draw();
   wp_table.columns.adjust().responsive.recalc();
 }).fail( function(jqXHR, textStatus, errorThrown) {
   var resp=jqXHR.responseJSON;
   var status=jqXHR.status;
   if(status == 401){
    toastr.error(resp.msg);
    logout();
  }else{
   toastr.error(resp.msg);
 }
});
}
//Funcion status//
function status(wpid, wpactive) {
  var status='<span class="badge badge-'+wpactive+'">'+wpid+'</span>'; 
  actions_cell = status;
  return actions_cell;
}
//Funcion para botones de accion//
function actions(wpid,img,pdf) {
  actions_cell = '<button class="btn btn-info view_detail" data-data1="' + wpid + '" ><i class="fas fa-hand-holding-usd"></i></button>';
  return actions_cell;
}
//Campo vacio para responsive//
function cel(wpid, wpactive) {
  actions_cell = '';
  return actions_cell;
}

dataTable_init();

//Detalles de propiedad//
$(document).on('click', '.view_detail', function(e){
  var id = $(this).data('data1');
  if (typeof id == 'undefined' || id === null || id === '') {  
    toastr.error('<?php echo $_SESSION['lang']['REQUERIDOS1']?>');
  } else {
    data = {'option':'<?php echo $decryp->encryptroute_agencie('view/commissions_reports/details_comisions')?>','id':id};
    $.post('<?php echo $url_admin;?>core/process2.php', data)
    .done(function(resp){ 
      $('#viewcat').modal('show'); 
      $('#detalles').html('<div class="form-group col-sm-3"><label >N°-poliza</label></div><div class="form-group col-sm-3"><label>Tipo.V</label></div><div class="form-group col-sm-3"><label >Total $</label></div><div class="form-group col-sm-3"><label style="color:red;"> Comision $</label></div>');
      var comision_total=0.00;
      $.each(resp.buy_master, function (k, v) {
        var totalpago=v.totalpago;
        var comision=v.comision;
        var suma = (totalpago*comision)/100;
        comision_total=comision_total+suma;
        suma=(formatterDolar.format(suma));
        suma=suma.replace('BSF', '');
        totalpago=(formatterDolar.format(totalpago));
        totalpago=totalpago.replace('BSF', '');
        $('#detalles').append('<div class="form-group col-sm-3"><label >'+v.id+'</label></div><div class="form-group col-sm-3"><label >Propia</label></div><div class="form-group col-sm-3"><label >'+totalpago+'</label></div><div class="form-group col-sm-3"><label style="color:red;">'+suma+' $</label></div>');
      });
      var i=0;
      for (var i = 0; i < resp.buy_agencias.length; i++) {
      $.each(resp.buy_agencias[i], function (a, b) {
        var totalpago=b.totalpago;
        var comision=b.comision;
        var suma = (totalpago*comision)/100;
        comision_total=comision_total+suma;
        suma=(formatterDolar.format(suma));
        suma=suma.replace('BSF', '');
        totalpago=(formatterDolar.format(totalpago));
        totalpago=totalpago.replace('BSF', '');
        $('#detalles').append('<div class="form-group col-sm-3"><label >'+b.id+'</label></div><div class="form-group col-sm-3"><label >Agencia</label></div><div class="form-group col-sm-3"><label >'+totalpago+'</label></div><div class="form-group col-sm-3"><label style="color:red;">'+suma+' $</label></div>');
      i++;
      });
      }
      for (var i = 0; i < resp.buy_asesores.length; i++) {
      $.each(resp.buy_asesores[i], function (c, d) {
        var totalpago=d.totalpago;
        var comision=d.comision;
        var suma = (totalpago*comision)/100;
        comision_total=comision_total+suma;
        suma=(formatterDolar.format(suma));
        suma=suma.replace('BSF', '');
        totalpago=(formatterDolar.format(totalpago));
        totalpago=totalpago.replace('BSF', '');
        $('#detalles').append('<div class="form-group col-sm-3"><label >'+d.id+'</label></div><div class="form-group col-sm-3"><label >Asesor</label></div><div class="form-group col-sm-3"><label >'+totalpago+'</label></div><div class="form-group col-sm-3"><label style="color:red;">'+suma+' $</label></div>');
      });
      }
      comision_total=(formatterDolar.format(comision_total));
      comision_total=comision_total.replace('BSF', '');
      $('#detalles').append('<div class="form-group col-sm-9 text-center"><label >Total$</label></div><div class="form-group col-sm-3"><label style="color:red;">'+comision_total+' $</label></div>');

    }).fail( function(jqXHR, textStatus, errorThrown) {
     var resp=jqXHR.responseJSON;
     var status=jqXHR.status;
     if(status == 401){
      toastr.error(resp.msg);
      logout();
    }else{
     toastr.error(resp.msg);
   }
 });
  }
});


});
</script>