<?php
require_once('includes/definition.php');
require_once('includes/send_email.php');

class advisers_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;
    private $correo_1;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
        $this->correo_1= new emails();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_advisers($datos){
    $user=$_SESSION['bn_user_global_agencias'];
    $perfil=$_SESSION['bn_perfil'];

    if (is_null($datos)) {  
        if ($perfil == "3") { 
        $consulta=$this->db->query("SELECT b.id_adviser as id,b.name_adviser as name,b.surname_adviser as apellidos,lpad(b.id_adviser , 6, 0) as code,b.email_adviser as email,s.status_name as status,s.status_color as color,(SELECT name_agency FROM agencies WHERE id_agency=b.id_agency) as padre FROM advisers as b INNER JOIN status as s ON (b.id_status=s.id_status)");
        }else{
        $consulta=$this->db->query("SELECT b.id_adviser as id,b.name_adviser as name,b.surname_adviser as apellidos,lpad(b.id_adviser , 6, 0) as code,b.email_adviser as email,s.status_name as status,s.status_color as color,(SELECT name_agency FROM agencies WHERE id_agency=b.id_agency) as padre FROM advisers as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE b.id_agency='$user'");  
        }
    }else{
        $consulta=$this->db->query("SELECT b.id_adviser as id,b.name_adviser as name,b.id_status as status,b.surname_adviser as apellidos,b.email_adviser as email FROM advisers as b WHERE b.id_adviser='$datos' AND  b.id_agency='$user'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de comision.
*
* Consulta de comision registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de comision registrados
* @param Int $datos id del usuario
*/
public function query_comision($opcion,$agencia){
    if ($opcion == 1) {   
        $consulta=$this->db->query("SELECT b.id_product as id FROM advisers_commissions as b WHERE b.id_adviser='$agencia' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas['id'];
        }
    }else{
        $consulta=$this->db->query("SELECT ag.id_product as id,ag.commission as comision,p.name_product as name FROM advisers_commissions as ag INNER JOIN products as p ON (ag.id_product=p.id_product) WHERE ag.id_adviser='$agencia' ");
        $query=[];
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas;
        }}
        return $query;
    }

/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
/*public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM advisers WHERE email_adviser='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM advisers WHERE email_adviser='$datos' AND id_adviser !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}

/**
* Chequear si nombre de usuario existe.
*
*Funcion para chequear nombre de usuario existe*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de usuario,Int $id id del usuario
*/
public function check_name ($datos,$id){
    $consulta1=$this->db->query("SELECT 1 FROM users WHERE email_user='$datos'"); 
    $consulta2=$this->db->query("SELECT 1 FROM agencies WHERE email_agency='$datos'"); 
    if (is_null($id)) {
        $consulta3=$this->db->query("SELECT 1 FROM advisers WHERE email_adviser='$datos'");
    }else{
        $consulta3=$this->db->query("SELECT 1 FROM advisers WHERE email_adviser='$datos' AND id_adviser !='$id' ");
    }
    $count_consulta1=$consulta1->num_rows;
    $count_consulta2=$consulta2->num_rows;
    $count_consulta3=$consulta3->num_rows;
    if ($count_consulta1 > 0 || $count_consulta2 > 0 || $count_consulta3 > 0) {
        return false;
    }
    return true;
    
}

/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
/*public function check_code ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM advisers WHERE code_advise='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM advisers WHERE code_advise='$datos' AND id_adviser !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_adviser($name,$apellidos,$productos,$comision,$email_a,$user,$clave_encrypt,$body_mail){
    $date=date('Y-m-d H:i:s');
    $perfil=$_SESSION['bn_perfil'];
    $id_a=($perfil == "3") ? 1 : $user;
    $insert=$this->db->query("INSERT INTO advisers(name_adviser,surname_adviser,email_adviser,id_user,create_date,id_agency,pass_adviser) VALUES ('$name','$apellidos','$email_a','$user','$date','$id_a','$clave_encrypt')");
    if ($insert) {
        $id=$this->db->insert_id;
        $x=count($productos);
        for ($i=0; $i < $x; $i++) { 
            $value=str_replace('.','',$comision[$i]);
            $value=str_replace(',','.', $value);
            $insert=$this->db->query("INSERT INTO advisers_commissions(id_adviser,id_product,commission) VALUES ('$id','$productos[$i]','$value')");
        }
        $send=$this->correo_1->send_email($email_a,$name,'Bienvenido a Bee Insurance',$body_mail);
        if (!$send) {
        return ['status'=>false,'code'=>'1'];
        }
    }
        return ['status'=>$insert,'code'=>'2'];
    }


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_exist_product ($datos,$agencia){
   $consulta=$this->db->query("SELECT 1 FROM advisers_commissions as b  WHERE b.id_product='$datos' AND b.id_adviser='$agencia' ");
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return false;
    }
    return true;
}    
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_adviser($name,$apellidos,$productos,$comision,$email_a,$status,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE advisers SET name_adviser='$name',surname_adviser='$apellidos',email_adviser='$email_a',id_status='$status',id_user='$user',create_date='$date' WHERE id_adviser='$id' AND id_agency='$user' ");
    if ($update) {
        $x=count($productos);
        for ($i=0; $i < $x; $i++) { 
            $value=str_replace('.','',$comision[$i]);
            $value=str_replace(',','.', $value);

            $valid=$this->check_exist_product($productos[$i],$id);
            if (!$valid) {
            $update=$this->db->query("INSERT INTO advisers_commissions(id_adviser,id_product,commission) VALUES ('$id','$productos[$i]','$value')");
            }else{
            $update=$this->db->query("UPDATE advisers_commissions SET commission='$value' WHERE id_product='$productos[$i]' AND id_adviser='$id' ");
            }
            //$update=$this->db->query("UPDATE advisers_commissions SET commission='$value' WHERE id_product='$productos[$i]' AND id_adviser='$id' ");

        }
    }
    return $update;
}
/**
* Chequear si adviser.
*
*Funcion para validar si adviser existe*
*
* @return Boolean  
* @param Int $id id de adviser
*/
public function check_adviser($id){
    $user=$_SESSION['bn_user_global_agencias'];
    $consulta=$this->db->query("SELECT 1 FROM advisers WHERE id_adviser='$id' AND id_agency='$user'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
/*public function check_game($id){
    $consulta=$this->db->query("SELECT 1 FROM games WHERE id_adviser='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_adviser($id){
    $delete=$this->db->query("DELETE FROM advisers WHERE id_adviser='$id'");
    return $delete;
}
/**
* Consulta de productos.
*
* Consulta de productos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de productos registrados
*/
public function select_products($datos,$perfil,$agencia){
    if (is_null($datos)) {   
        if ($perfil == "3") {
            $consulta=$this->db->query("SELECT b.id_product as id,b.name_product as name,b.percentage_advisers as comision FROM products as b WHERE b.id_status=1 ");
        }else{
            $consulta=$this->db->query("SELECT ag.id_product as id,ag.commission as comision,p.name_product as name FROM agencies_commissions as ag INNER JOIN products as p ON (ag.id_product=p.id_product) WHERE ag.id_agency='$agencia' ");  
        }
    }else{
        if ($perfil == "3") {
            $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_product='$datos' AND b.id_status=1 ");
        }else{
            $consulta=$this->db->query("SELECT 1 FROM agencies_commissions as b WHERE b.id_product='$datos' AND b.id_agency='$agencia' ");
        }

    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Consulta de comision.
*
* Consulta de comision registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de comision registrados
* @param Int $datos id del usuario
*/
public function check_comision($datos,$comision,$perfil,$agencia){
    if ($perfil == "3") {
    $consulta=$this->db->query("SELECT 1 FROM products as b  WHERE b.id_product='$datos' AND b.percentage_advisers >=$comision ");
    }else{
    $consulta=$this->db->query("SELECT 1 FROM agencies_commissions as b  WHERE b.id_product='$datos' AND b.commission >=$comision AND b.id_agency='$agencia' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return false;
    }
    return true;
}

}
?>