<?php
require_once('includes/definition.php');

class age_groups_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_age_groups($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_group as id,b.start_age as edad_d,b.end_age as edad_h,s.status_name as status,s.status_color as color FROM age_groups as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_group as id,b.start_age as edad_d,b.end_age as edad_h,b.id_status as status FROM age_groups as b WHERE b.id_group='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($edad_d,$edad_h,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM age_groups WHERE start_age='$edad_d' AND end_age='$edad_h' ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM age_groups WHERE start_age='$edad_d' AND end_age='$edad_h' AND id_group !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_age_group($edad_d,$edad_h,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO age_groups(start_age,end_age,id_user,create_date) VALUES ('$edad_d','$edad_h','$user','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_age_group($edad_d,$edad_h,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE age_groups SET start_age='$edad_d',end_age='$edad_h',id_status='$status',id_user='$user',create_date='$date' WHERE id_group='$id'");
    return $update;
}
/**
* Chequear si age_group.
*
*Funcion para validar si age_group existe*
*
* @return Boolean  
* @param Int $id id de age_group
*/
public function check_age_group($id){
    $consulta=$this->db->query("SELECT 1 FROM age_groups WHERE id_group='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_blog($id){
    $consulta=$this->db->query("SELECT 1 FROM blog_age_groups WHERE id_group='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_age_group($id){
    $delete=$this->db->query("DELETE FROM age_groups WHERE id_group='$id'");
    return $delete;
}

}
?>