<?php
require_once('includes/definition.php');
require_once('includes/send_email.php');
//require_once('controller/reports_certificate_controller.php');

class campaigns_push_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;
    private $correo_1;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
        $this->correo_1= new emails();
    }

/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function query_campaigns_push($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_push as id,b.name_push as name,DATE_FORMAT(b.start_date, '%Y-%m-%d') as fecha_inicio,DATE_FORMAT(b.end_date, '%Y-%m-%d') as fecha_fin,u.user_name as usuario,b.id_status,s.status_name as status,s.status_color as color FROM campaigns_push as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN users as u ON (b.id_user=u.id_user) ORDER BY b.id_push DESC");
    }else{
        $consulta=$this->db->query("SELECT b.id_push as id,b.name_push as name,DATE_FORMAT(b.start_date, '%Y-%m-%d') as fecha_inicio,DATE_FORMAT(b.end_date, '%Y-%m-%d') as fecha_fin,b.id_status as status FROM campaigns_push as b WHERE b.id_push='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function dateils_campaigns_push($datos){
    //$consulta=$this->db->query("SELECT b.name_push as name,DATE_FORMAT(b.start_date, '%Y-%m-%d') as fecha_inicio,DATE_FORMAT(b.end_date, '%Y-%m-%d') as fecha_fin,u.user_name as usuario,b.id_status,s.status_name as status,s.status_color as color FROM campaigns_push as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN users as u ON (b.id_user=u.id_user) WHERE b.id_push='$datos'");
    $consulta=$this->db->query("SELECT b.id_push as id,b.name_push as name,DATE_FORMAT(b.start_date, '%m/%d/%Y') as fecha_inicio,DATE_FORMAT(b.end_date, '%m/%d/%Y') as fecha_fin,b.id_status as status FROM campaigns_push as b WHERE b.id_push='$datos'");

    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function dateils_campaign_item($datos){
    $consulta=$this->db->query("SELECT *,u.user_name as usuario FROM campaigns_push_details as b INNER JOIN users as u ON (b.id_user=u.id_user) WHERE b.id_push='$datos' ORDER BY id_detail ASC ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Validar de categorias.
*
* Validar de categorias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de categorias registrados
* @param Int $datos id del usuario
*/
public function check_lists_campaigns_push($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
        $consulta=$this->db->query("SELECT b.id_list as id FROM campaigns_push_lists as b WHERE b.id_push='$datos' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas['id'];
        }
    }else{
        $consulta=$this->db->query("SELECT b.id_list as id, c.name_list as name FROM campaigns_push_lists as b INNER JOIN lists as c ON (b.id_list=c.id_list) WHERE b.id_push='$datos' ");
        while($filas=$consulta->fetch_assoc()){
            $query[]=$filas;
        }
    }
    return $query;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
/*function validateDate_now($date)
{
    $fecha=date('Y-m-d');
    $fechai = date("Y-m-d", strtotime($fecha));
    $fechaf = date("Y-m-d", strtotime($date));
    $date1=date_create($fechai);
    $date2 = date_create($fechaf);
    $diff = $date1->diff($date2);
    $diff= $diff->format('%R%a');
    $diff = substr($diff, 0,1);
    if($diff == "-"){
        return false;
    }else{
        return true;
    }
}
/**
* Chequear si nombre de Campaña existe.
*
*Funcion para consultar nombre de Campaña registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de Campaña,Int $id del Campaña
*/
public function check_status ($datos){
    $datos=trim($datos);
    $consulta=$this->db->query("SELECT 1 FROM status WHERE id_status ='$datos' AND (id_status ='1' OR id_status=2 OR id_status=4) ");
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si nombre de Campaña existe.
*
*Funcion para consultar nombre de Campaña registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de Campaña,Int $id del Campaña
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM campaigns_push WHERE name_push='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM campaigns_push WHERE name_push='$datos' AND id_push !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}

/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function register_campaigns_push($name,$asunto,$fecha_e,$descripcion,$listas,$status,$user,$opcion_push){
    $date=date('Y-m-d H:i:s');
    $fecha_a=date('Y-m-d');
    $fecha_e = explode("-", $fecha_e);
    $fecha_inicio = date("Y-m-d", strtotime($fecha_e[0]));
    $fecha_fin = date("Y-m-d", strtotime($fecha_e[1]));
    $insert=$this->db->query("INSERT INTO campaigns_push(name_push,start_date,end_date,id_status,id_user,create_date) VALUES ('$name','$fecha_inicio','$fecha_fin','$status','$user','$date')");
    if ($insert) {
        $id=$this->db->insert_id;
        $descripcion = str_replace ("'", "&apos;",$descripcion);
        $insert=$this->db->query("INSERT INTO campaigns_push_details(id_push,subject_push,type_push,description_push,id_user,create_date) VALUES ('$id','$asunto','1','$descripcion','$user','$date')");
        $id1=$this->db->insert_id;
        foreach ($listas as $value) {
            $insert=$this->db->query("INSERT INTO campaigns_push_lists(id_list,id_push,id_user,create_date) VALUES ($value,$id,'$user','$date')");
        }
        if ($status=="1" & $fecha_a == $fecha_inicio) {
            $insert=$this->debug_lists($listas,$asunto,$descripcion,$id,$status,$fecha_inicio,$user,$id1,$opcion_push);
        }
    }
    return ['status'=>$insert,'id'=>$id];
}
/**
* Registrar Item Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function register_items_push($asuntos,$periodos,$descripcions,$id,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_a=date('Y-m-d');

    $x=0;
    foreach ($asuntos as $asunto) {
        $periodo=$periodos[$x];
        $descripcion=$descripcions[$x];
        $descripcion = str_replace ("'", "&apos;",$descripcion);
        $insert=$this->db->query("INSERT INTO campaigns_push_details(id_push,subject_push,type_push,period_days,description_push,id_user,create_date) VALUES ('$id','$asunto','2','$periodo','$descripcion','$user','$date')");
        $x++;
    }
    return ['status'=>$insert];

}
/**
* Editar Campaña.
*
*Funcion para editar Campaña*
*
* @return Boolean  
*/
public function edit_campaigns_push($agregar_s,$eliminar_s,$name,$fecha_e,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $fecha_a=date('Y-m-d');
    if (count($eliminar_s) > 0) {
        foreach ($eliminar_s as $e_emp) {
            $dato1=$this->db->query("DELETE FROM campaigns_push_lists WHERE id_list='$e_emp' AND id_push='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_s) > 0) {
        foreach ($agregar_s as $a_emp) {
            $dato2=$this->db->query("INSERT INTO campaigns_push_lists(id_list,id_push,id_user,create_date) VALUES ('$a_emp','$id','$user','$date')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }
    $fecha_e = explode("-", $fecha_e);
    $fecha_inicio = date("Y-m-d", strtotime($fecha_e[0]));
    $fecha_fin = date("Y-m-d", strtotime($fecha_e[1]));
    $update=$this->db->query("UPDATE campaigns_push SET name_push='$name',start_date='$fecha_inicio',end_date='$fecha_fin',id_status='$status',id_user='$user',create_date='$date' WHERE id_push='$id'");
    return $update;
}
/**
* Depurar listado de suscriptores.
*
*Funcion para depurar cantidad de suscriptores para la el envio*
*
* @return Boolean  
*/
public function debug_lists($listas,$asunto,$descripcion,$id,$status,$fecha_inicio,$user,$detalle,$opcion_push){
    //$class=new reports_certificates();
    $decryp=new routehelper();

    foreach ($listas as $value) {
        $consulta=$this->db->query("SELECT b.id_subscriber as id,b.id_list as lista,s.name_subscriber as name,s.email_subscriber as email,s.surname_subscriber as apellido,s.date_birth as fecha_n,s.date_start as salida,s.date_expiration as fin FROM subscriber_lists as b INNER JOIN subscribers as s ON (b.id_subscriber=s.id_subscriber) WHERE b.id_list='$value' AND s.id_status='1' AND (email_subscriber !='#' OR email_subscriber='' OR email_subscriber IS NULL) ORDER BY b.id_subscriber ASC");
        while($filas=$consulta->fetch_assoc()){
            $query=[];
            /*if ($opcion_push == '1') {            
                $archivo=$class->pdf_subscriber($filas['id'],$filas['name'],$filas['apellido'],$filas['email'],$filas['fecha_n'],$filas['salida'],$filas['fin']);
                $userid=$filas['id'];
                $update=$this->db->query("UPDATE subscribers SET source_subscriber='$archivo' WHERE id_subscriber='$userid'");
                $filas['archivo']=$archivo;
            }*/
            $push_e=$detalle.'/'.$filas['id'];
            $push_e=$decryp->encryptroute_push($push_e);
            $filas['push_encrypt']=$push_e;
            $query[]=$filas;

            $send=$this->correo_1->send_campaign($query,$asunto,$descripcion);
            if ($send['status']) {
                $suscriptores_send=$send['completos'];
                $suscriptores_fail=$send['fallidos'];
                if ($status !== "7") {
                    $send=$this->suscriptores_send($suscriptores_send,$detalle,$user);
                    $send1=$this->suscriptores_fail($suscriptores_fail,$detalle,$user);
                }
                //return true;
            }else{
                //return false;
                break;
            }
        }


        return $send;

    }

}
/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function suscriptores_send($suscriptores,$push,$user){
    $user=(is_null($user))?'NULL':$user;
    $date=date('Y-m-d H:i:s');
    $fecha=date('Y-m-d');
    foreach ($suscriptores as $value) {
        $suscriptor=$value->id;
        $lista=$value->lista;
        $insert=$this->db->query("INSERT INTO campaigns_push_send(id_detail,id_subscriber,id_list,date_send,id_user,create_date) VALUES ('$push','$suscriptor','$lista','$fecha',$user,'$date')");
    }
    return $insert;
}
/**
* Registrar Campaña.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function suscriptores_fail($suscriptores,$push,$user){
    $date=date('Y-m-d H:i:s');
    $fecha=date('Y-m-d');
    foreach ($suscriptores as $value) {
        $suscriptor=$value->id;
        $lista=$value->lista;
        $insert=$this->db->query("INSERT INTO campaigns_push_fails(id_detail,id_subscriber,id_list,date_send,id_user,create_date) VALUES ('$push','$suscriptor','$lista','$fecha',$user,'$date')");
    }
    return $insert;
}
/**
* Chequear si campaign.
*
*Funcion para validar si campaign existe*
*
* @return Boolean  
* @param Int $id id de campaign
*/
public function check_campaign($id){
    $consulta=$this->db->query("SELECT 1 FROM campaigns_push WHERE id_push='$id' ");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Registrar Campaña Duplicada.
*
*Funcion para registrar Campaña*
*
* @return Boolean  
*/
public function duplicate_campaigns_push($datos,$listas,$items,$user){
    $date=date('Y-m-d H:i:s');
    $fecha_e=date('Y-m-d');
    foreach ($datos as $value) {
        $name=$value['name'].' Duplicada';
        $fecha_inicio=$value['fecha_inicio'];
        $fecha_fin=$value['fecha_fin'];
        $insert=$this->db->query("INSERT INTO campaigns_push(name_push,start_date,end_date,id_status,id_user,create_date) VALUES ('$name','$fecha_inicio','$fecha_fin','4','$user','$date')");
        if ($insert) {
            $id=$this->db->insert_id;
            foreach ($listas as $value) {
                $value1=$value['id'];
                $insert=$this->db->query("INSERT INTO campaigns_push_lists(id_list,id_push,id_user,create_date) VALUES ($value1,$id,'$user','$date')");
            }
            foreach ($items as $value) {
                $type_push=$value['type_push'];
                $subject_push=$value['subject_push'];
                $period_days=$value['period_days'];
                $period_days=(is_null($period_days))?"NULL":$period_days;
                $description_push=$value['description_push'];
                $insert=$this->db->query("INSERT INTO campaigns_push_details(id_push,subject_push,type_push,period_days,description_push,id_user,create_date) VALUES ('$id','$subject_push','$type_push',$period_days,'$description_push','$user','$date')");
            }

        }
    }
    return $insert;
}
/**
* Chequear si campaign.
*
*Funcion para validar si campaign existe*
*
* @return Boolean  
* @param Int $id id de campaign
*/
public function check_campaign_item($id,$detalle){
    $consulta=$this->db->query("SELECT 1 FROM campaigns_push_details WHERE id_push='$id' AND id_detail='$detalle' ");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Editar item.
*
*Funcion para editar item*
*
* @return Boolean  
*/
public function edit_item_push($asunto,$periodos,$descripcion,$user,$id,$detalle){
    $date=date('Y-m-d H:i:s');
    $descripcion = str_replace ("'", "&apos;",$descripcion);
    $update=$this->db->query("UPDATE campaigns_push_details SET subject_push='$asunto',period_days=$periodos,description_push='$descripcion',id_user='$user',create_date='$date' WHERE id_detail='$detalle' AND id_push='$id'");
    return $update;
}
/**
* Eliminar Campaña.
*
*Funcion para eliminar Campaña*
*
* @return Boolean  
* @param Int $id id de Campaña
*/
public function delete_item($id){
    $delete=$this->db->query("DELETE FROM campaigns_push_details WHERE id_detail='$id' AND type_push='2'");
    return $delete;
}
/**
* Eliminar Campaña.
*
*Funcion para eliminar Campaña*
*
* @return Boolean  
* @param Int $id id de Campaña
*/
public function delete_campaigns_push($id){
    $delete=$this->db->query("DELETE FROM campaigns_push WHERE id_push='$id'");
    return $delete;
}
/**
* Consulta de campaign recibidad.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber($datos,$lista){
    if (empty($lista)) {   
        $consulta=$this->db->query("SELECT b.id_push_send as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,cp.subject_push as asunto,DATE_FORMAT(b.date_send, '%Y-%m-%d') as fecha,u.reference as localizador,u.source_subscriber as archivo,u.phones_subscriber as telefono  FROM campaigns_push_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE cp.id_push='$datos'  ORDER BY b.date_send ASC");
    }else{
        $consulta=$this->db->query("SELECT b.id_push_send as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,u.reference as localizador,u.source_subscriber as archivo  FROM campaigns_push_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE cp.id_push='$datos' AND b.id_list='$lista'  ORDER BY b.date_send ASC");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber_no($datos,$lista){
    if (empty($lista)) {   
        $consulta=$this->db->query("SELECT 0 as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,cp.subject_push as asunto,DATE_FORMAT(b.date_send, '%Y-%m-%d') as fecha,u.reference as localizador,u.source_subscriber as archivo,u.phones_subscriber as telefono  FROM campaigns_push_fails as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE cp.id_push='$datos'  ORDER BY b.date_send ASC");
    }else{
        $consulta=$this->db->query("SELECT CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,l.name_list as lista  FROM campaigns_push_fails as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE cp.id_push='$datos' AND b.id_list='$lista' ORDER BY b.date_send ASC");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign recibidad.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber_visiontotal($datos,$fechai,$fechaf){
   
   if (is_null($fechai)) {
    $fechai = date("Y-m-01");
    $fechaf = date("Y-m-t");    
   }
   $consulta=$this->db->query("SELECT u.id_visiontravel as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,cp.subject_push as asunto,DATE_FORMAT(b.date_send, '%Y-%m-%d') as fecha,u.reference as localizador,u.source_subscriber as archivo,u.phones_subscriber as telefono,u.date_issue as emision  FROM campaigns_push_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE b.date_send BETWEEN '$fechai' AND '$fechaf' AND cp.id_push='$datos' ORDER BY b.date_send ASC ");

    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign recibidad.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber_vision($datos){
   
   $consulta=$this->db->query("SELECT u.id_visiontravel as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,cp.subject_push as asunto,DATE_FORMAT(b.date_send, '%Y-%m-%d') as fecha,u.reference as localizador,u.source_subscriber as archivo,u.phones_subscriber as telefono,u.date_issue as emision  FROM campaigns_push_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE cp.id_push='$datos' ORDER BY b.date_send ASC ");
    

   //$consulta=$this->db->query("SELECT u.id_visiontravel as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,cp.subject_push as asunto,DATE_FORMAT(b.date_send, '%Y-%m-%d') as fecha,u.reference as localizador,u.source_subscriber as archivo,u.phones_subscriber as telefono,u.date_issue as emision  FROM campaigns_push_send as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE b.date_send BETWEEN '2023-01-01' AND '2023-01-31' AND b.id_user='7' AND cp.id_push='$datos' ORDER BY b.date_send ASC ");


    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de campaign.
*
* Consulta de campaign registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de campaign registrados
* @param Int $datos id del usuario
*/
public function lists_subscriber_no_vision($datos){
    $consulta=$this->db->query("SELECT u.id_visiontravel as id,CONCAT(u.name_subscriber,' ',u.surname_subscriber) as nombres,u.email_subscriber as email,u.identification_subscriber as identificacion,l.name_list as lista,cp.subject_push as asunto,DATE_FORMAT(b.date_send, '%Y-%m-%d') as fecha,u.reference as localizador,u.source_subscriber as archivo,u.phones_subscriber as telefono,u.date_issue as emision  FROM campaigns_push_fails as b INNER JOIN lists as l ON (b.id_list=l.id_list) INNER JOIN subscribers as u ON (b.id_subscriber=u.id_subscriber) INNER JOIN campaigns_push_details as cp ON (b.id_detail=cp.id_detail) WHERE cp.id_push='$datos'  ORDER BY b.date_send ASC");

    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Consulta de subscriber.
*
* Consulta de subscriber registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de subscriber registrados
* @param Int $datos id del usuario
*/
public function query_subscribers($datos){
    $consulta=$this->db->query("SELECT b.id_subscriber as suscrictor,b.id_visiontravel as id,b.reference as localizador,b.name_subscriber as name,b.email_subscriber as email,b.surname_subscriber as apellido,b.phones_subscriber as tlf,b.date_birth as fecha_n,DATE_FORMAT(b.date_start, '%m/%d/%Y') as salida,DATE_FORMAT(b.date_expiration, '%m/%d/%Y') as llegada,b.identification_subscriber as cedula FROM subscribers as b WHERE b.id_visiontravel='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
*/
public function edit_asegurado($name,$apellido,$email,$tlf,$fecha_nac,$fechai,$fechaf,$identificacion,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE subscribers SET email_subscriber='$email',name_subscriber='$name',surname_subscriber='$apellido',phones_subscriber='$tlf',date_birth='$fecha_nac',date_start='$fechai',date_expiration='$fechaf',identification_subscriber='$identificacion',id_user='$user',create_date='$date' WHERE id_visiontravel='$id'");
    return $update;
}


/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
*/
public function edit_asegurado_pdf($archivo,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE subscribers SET source_subscriber='$archivo',id_user='$user',create_date='$date' WHERE id_subscriber='$id'");
    return $update;
}

/**
* Consulta de formularios.
*
* Consulta de formularios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de formularios registrados
* @param Int $datos id del usuario
*/
public function query_products($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_insurance as id,b.name_product as name FROM products as b ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_insurance='$datos' ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

}
?>