<?php
require_once('includes/definition.php');

class coupons_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de formularios.
*
* Consulta de formularios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de formularios registrados
* @param Int $datos id del usuario
*/
public function query_coupons($datos){
    $consulta=$this->db->query("SELECT b.id_coupon as id,b.type_coupon as tipo_c,b.amount_coupon as monto_c,b.name_coupon as name,b.code_coupon as code,b.start_date as desde,b.end_date as hasta FROM insurance_coupons as b WHERE b.id_status='1' AND b.id_insurance='$datos' ORDER BY b.id_coupon ASC ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
/**
* Chequear si coupon.
*
*Funcion para validar si coupon existe*
*
* @return Boolean  
* @param Int $id id de coupon
*/
public function check_coupon($id){
    $consulta=$this->db->query("SELECT 1 FROM insurance_coupons WHERE id_coupon='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si nombre de formulario existe.
*
*Funcion para consultar nombre de formulario registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de formulario,Int $id del formulario
*/
public function check_code ($datos,$id,$id_coupon){
    $datos=trim($datos);
    if (is_null($id_coupon)) {
        $consulta=$this->db->query("SELECT 1 FROM insurance_coupons WHERE code_coupon='$datos' AND id_insurance ='$id'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM insurance_coupons WHERE code_coupon='$datos' AND id_insurance ='$id' AND id_coupon !='$id_coupon' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar precio.
*
*Funcion para registrar precio*
*
* @return Boolean  
*/
public function register_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$desde,$hasta,$id,$user){
    $date=date('Y-m-d H:i:s');

    $insert=$this->db->query("INSERT INTO insurance_coupons(id_insurance,type_coupon,amount_coupon,name_coupon,code_coupon,start_date,end_date,id_user,create_date) VALUES ('$id','$tipo_cupon','$monto_cupon','$name_cupon','$code_cupon','$desde','$hasta','$user','$date')");
    return $insert;
}
/**
* Editar formulario.
*
*Funcion para editar formulario*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la formulario,String $doc ruc de la formulario,String $direccion direccion de la formulario,Int $status status de la formulario,Int $data1 id de formulario
*/
public function edit_coupon($name_cupon,$code_cupon,$tipo_cupon,$monto_cupon,$desde,$hasta,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE insurance_coupons SET name_coupon='$name_cupon',code_coupon='$code_cupon',type_coupon='$tipo_cupon',amount_coupon='$monto_cupon',start_date='$desde',end_date='$hasta',id_user='$user',create_date='$date' WHERE id_coupon='$id'");
    return $update;
}
/**
* Chequear si precio  tiene usuarios asignados.
*
*Funcion para validar si precio tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de precio
*/
/*public function check_game($id){
    $consulta=$this->db->query("SELECT 1 FROM games WHERE id_place='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar precio.
*
*Funcion para eliminar precio*
*
* @return Boolean  
* @param Int $id id de precio
*/
public function delete_coupon($id,$opcion,$user){
    $date=date('Y-m-d H:i:s');
    if ($opcion == 1) {
    $delete=$this->db->query("DELETE FROM insurance_coupons WHERE id_coupon='$id'");
    }else{
    $update=$this->db->query("UPDATE insurance_coupons SET id_status='2',id_user='$user',create_date='$date' WHERE id_coupon='$id'");  
    }
    return $delete;
}
}
?>