<?php
require_once('includes/definition.php');

class downloadable_files_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de Archivos.
*
* Consulta de Archivos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de Archivos registrados
*/
public function query_downloadable_files($datos,$opcion){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_file as id,b.name_file as name,b.description_file as description,b.title_file as titulo,s.status_name as status,s.status_color as color FROM downloadable_files as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE b.opcion_file='$opcion' ");
    }else{
        $consulta=$this->db->query("SELECT b.id_file as id,b.name_file as name,b.id_status as status,b.description_file as description,b.title_file as titulo FROM downloadable_files as b WHERE b.id_file='$datos' AND b.opcion_file='$opcion'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de Archivo existe.
*
*Funcion para consultar nombre de Archivo registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
*/
public function check_name ($datos,$id,$opcion){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM downloadable_files WHERE title_file='$datos' AND opcion_file='$opcion'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM downloadable_files WHERE title_file='$datos' AND opcion_file='$opcion' AND id_file !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar Archivo.
*
*Funcion para registrar Archivo*
*
* @return Boolean  
*/
public function register_downloadable_file($name,$opcion,$descripcion,$archivo,$user){
    $date=date('Y-m-d H:i:s');
    $name_archivo = str_replace(" ", "_", $name);
    $ext_pdf = pathinfo($archivo['name'], PATHINFO_EXTENSION);
    $name_pdf=$name_archivo.'.'.$ext_pdf;
    $insert=$this->db->query("INSERT INTO downloadable_files(name_file,description_file,title_file,opcion_file,id_user,create_date) VALUES ('$name_pdf','$descripcion','$name','$opcion','$user','$date')");
    if ($insert) {
    $location1=$_SESSION['ruta_img'].'downloadable_files/'.$name_pdf;
    move_uploaded_file($archivo['tmp_name'],$location1);
    }
    return $insert;
}
/**
* Editar Archivo.
*
*Funcion para editar Archivo*
*
* @return Boolean  
*/
public function edit_downloadable_file($name,$descripcion,$archivo,$status,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE downloadable_files SET title_file='$name',description_file='$descripcion',id_status='$status',id_user='$user',create_date='$date' WHERE id_file='$id'");
    $name_archivo = str_replace(" ", "_", $name);
    if (!is_null($archivo)) {
    $ext_pdf = pathinfo($archivo['name'], PATHINFO_EXTENSION);
    $name_pdf=$name_archivo.'.'.$ext_pdf;
    $location=$_SESSION['ruta_img'].'downloadable_files/'.$name_pdf;
    move_uploaded_file($archivo['tmp_name'],$location);
    $update=$this->db->query("UPDATE downloadable_files SET name_file='$name_pdf' WHERE id_file='$id'");
    }

    return $update;
}
/**
* Chequear si downloadable_file.
*
*Funcion para validar si downloadable_file existe*
*
* @return Boolean  
* @param Int $id id de downloadable_file
*/
public function check_downloadable_file($id,$opcion_file){
    $consulta=$this->db->query("SELECT 1 FROM downloadable_files WHERE id_file='$id' AND opcion_file='$opcion_file'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar Archivo.
*
*Funcion para eliminar Archivo*
*
* @return Boolean  
* @param Int $id id de Archivo
*/
public function delete_downloadable_file($id){
    $delete=$this->db->query("DELETE FROM downloadable_files WHERE id_file='$id'");
    if ($delete) {
    $nombre=$this->query_downloadable_files($id,2);
    $nombre=$nombre['name'];
    $location=$_SESSION['ruta_img'].'downloadable_files/'.$nombre;
    unlink($location);
    }
    return $delete;
}

}
?>