<?php
require_once('includes/definition.php');

class kiosks_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_kiosks($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_agency_ibo as id,b.name_agency as name,b.logo,b.token_encrypt as token,s.status_name as status,s.status_color as color FROM agencies_ibo as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_agency_ibo as id,b.name_agency as name,b.logo,b.id_status as status FROM agencies_ibo as b WHERE b.id_agency_ibo='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Consulta de productos.
*
* Consulta de productos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de productos registrados
*/
public function select_products($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_insurance as id,b.name_product as name FROM products as b WHERE b.id_status=1 ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_insurance='$datos' AND b.id_status=1 ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM agencies_ibo WHERE name_agency='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM agencies_ibo WHERE name_agency='$datos' AND id_agency_ibo !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Validar de etiqueta.
*
* Validar de etiqueta registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de etiqueta registrados
* @param Int $datos id del usuario
*/
public function check_products($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
    $consulta=$this->db->query("SELECT b.id_insurance as id FROM agencies_ibo_products as b WHERE b.id_agency_ibo='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas['id'];
    }
    }else{
    $consulta=$this->db->query("SELECT b.id_insurance as id, c.name_product as name FROM agencies_ibo_products as b INNER JOIN products as c ON (b.id_insurance=c.id_insurance) WHERE b.id_agency_ibo='$datos' ");

    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    }
    return $query;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_kiosk($name,$productos,$imagen,$status,$user,$token){
    require_once('includes/encrypt.php');
    $decrypt=new encrypthelper();

    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO agencies_ibo(name_agency, id_status,id_user,create_date) VALUES ('$name','$status','$user','$date')");
    if ($insert) {
    $id=$this->db->insert_id;
    foreach ($productos as $value) {
    $insert=$this->db->query("INSERT INTO agencies_ibo_products(id_insurance,id_agency_ibo) VALUES ('$value','$id')");
    }

    $name_archivo = 'Agency_ibo_'.$id;
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;

    $route = $id.'/beeibo_2022/'.$token ;
    $route = $decrypt->encode($route);

    $insert=$this->db->query("UPDATE agencies_ibo SET logo='$name_image',token='$token',token_encrypt='$route' WHERE id_agency_ibo='$id'");

    $location=$_SESSION['ruta_img'].'agencies_ibo/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);

    }
    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_kiosk($name,$status,$agregar_s,$eliminar_s,$imagen,$user,$id){
    $date=date('Y-m-d H:i:s');

    if (count($eliminar_s) > 0) {
        foreach ($eliminar_s as $e_emp) {
            $dato1=$this->db->query("DELETE FROM agencies_ibo_products WHERE id_insurance='$e_emp' AND id_agency_ibo='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_s) > 0) {
        foreach ($agregar_s as $a_emp) {
            $dato2=$this->db->query("INSERT INTO agencies_ibo_products(id_agency_ibo,id_insurance) VALUES ('$id','$a_emp')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }


    $update=$this->db->query("UPDATE agencies_ibo SET name_agency='$name',id_status='$status',id_user='$user',create_date='$date' WHERE id_agency_ibo='$id'");


    $name_archivo = 'Agency_ibo_'.$id;
    if (!is_null($imagen)) {
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $location=$_SESSION['ruta_img'].'agencies_ibo/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    $update=$this->db->query("UPDATE agencies_ibo SET logo='$name_image' WHERE id_agency_ibo='$id'");
    }


    return $update;
}
/**
* Chequear si kiosk.
*
*Funcion para validar si kiosk existe*
*
* @return Boolean  
* @param Int $id id de kiosk
*/
public function check_kiosk($id){
    $consulta=$this->db->query("SELECT 1 FROM agencies_ibo WHERE id_agency_ibo='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_buy($id){
    $consulta=$this->db->query("SELECT 1 FROM  insurance_buy WHERE id_agency_ibo='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_kiosk($id){
    $delete=$this->db->query("DELETE FROM agencies_ibo WHERE id_agency_ibo='$id'");
    return $delete;
}

}
?>