<?php
require_once('includes/definition.php');
class network_reports_model{
    
    private $db;
    private $query;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
    }


/**
* Consulta de agencias master.
*
* Consulta de agencias master registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de agencias master registrados
* @param Int $datos id del usuario
*/
public function query_agencies_masters(){
    $consulta=$this->db->query("SELECT b.id_agency as id,b.name_agency as name FROM agencies as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE b.level_agency = 1 OR b.id_agency='1' ORDER BY b.id_agency ASC ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Consulta de agencias.
*
* Consulta de agencias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de agencias registrados
* @param Int $datos id del usuario
*/
public function query_agencies($user){
    $consulta=$this->db->query("SELECT b.id_agency as id,b.name_agency as name FROM agencies as b WHERE b.level_agency = 2 AND b.id_father='$user' ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_advisers($user){
    $consulta=$this->db->query("SELECT b.id_adviser as id,CONCAT(b.name_adviser,' ', b.surname_adviser) as name,lpad(b.id_adviser , 6, 0) as code,b.id_agency as agencia FROM advisers as b WHERE b.id_agency='$user' ");
    $count=$consulta->num_rows;
    return $consulta;
}


}
?>