<?php
require_once('core/includes/definition.php');

class reports_insurance_model{
    private $db;
    private $dato1;
    private $dato2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->dato1=array();
        $this->dato2=array();
    }

/**
* Consulta de servicios.
*
* Consulta de servicios la consulta se hace por id*
*
* @return Array de  roles asignadas
* @param Int $datos id del usuario
*/
public function query_buy($buy){
    $consulta=$this->db->query("SELECT buy.*,pay.total_payment as pago,c.name_country as pais,pri.price_insurance as precio,pri.descripcion_price as descripcion_precio,CASE WHEN buy.id_agency THEN 'Agencia' WHEN buy.id_adviser THEN 'Asesor' WHEN buy.id_agency_ibo THEN 'Agencia IBO' ELSE 'Web' END AS perfil,CONCAT(ad.name_adviser,' ',ad.surname_adviser) as nombre_asesor,CONCAT(ag.name_agency) as nombre_agencia,lpad(ad.id_adviser , 6, 0) as code_ase,lpad(ag.id_agency , 6, 0) as code_age,i.title_pdf FROM insurance_buy as buy INNER JOIN insurance_payment as pay ON (buy.id_buy=pay.id_buy) INNER JOIN countries as c ON (buy.id_country=c.iso) INNER JOIN insurance_prices as pri ON (buy.id_price=pri.id_price) INNER JOIN insurances as i ON (buy.id_insurance=i.id_insurance) LEFT JOIN advisers as ad ON (buy.id_adviser=ad.id_adviser) LEFT JOIN agencies as ag ON (buy.id_agency=ag.id_agency) LEFT JOIN agencies_ibo as ag_ibo ON (buy.id_agency_ibo=ag_ibo.id_agency_ibo) WHERE buy.id_status='8' AND buy.id_buy='$buy'");
    $dato1=[];
    while($filas=$consulta->fetch_assoc()){
        $dato1[]=$filas;
    }
    return $dato1;
}
/**
* Consulta de servicios.
*
* Consulta de servicios la consulta se hace por id*
*
* @return Array de  roles asignadas
* @param Int $datos id del usuario
*/
public function query_beneficiarios($buy){
    $consulta=$this->db->query("SELECT * FROM insurance_beneficiaries WHERE id_buy='$buy' ORDER BY name_beneficiary ASC");

    while($filas=$consulta->fetch_assoc()){
        $this->dato2[]=$filas;
    }
    return $this->dato2;
}
/**
* Consulta de servicios.
*
* Consulta de servicios la consulta se hace por id*
*
* @return Array de  roles asignadas
* @param Int $datos id del usuario
*/
public function query_declaracion($buy){
    $consulta=$this->db->query("SELECT de.* FROM declaration_health as de INNER JOIN insurance_declaration_health as id ON (de.id_declaration_health=id.id_declaration_health) WHERE id.id_insurance='$buy' ORDER BY de.id_declaration_health ASC");

    $dato1=[];
    while($filas=$consulta->fetch_assoc()){
        $dato1[]=$filas;
    }
    return $dato1;
}
/**
* Consulta de servicios.
*
* Consulta de servicios la consulta se hace por id*
*
* @return Array de  roles asignadas
* @param Int $datos id del usuario
*/
public function query_declaracion_resp($declaration,$buy){
    $consulta=$this->db->query("SELECT * FROM insurance_buy_declaration WHERE id_declaration_health='$declaration' AND id_buy='$buy'");

    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return ['status'=>false];
    }else{
    while($filas=$consulta->fetch_assoc()){
        $descripcion=$filas['description'];
    }
    return ['status'=>true,'descripcion'=>$descripcion];
    }
}
/**
* Consulta de servicios.
*
* Consulta de servicios la consulta se hace por id*
*
* @return Array de  roles asignadas
* @param Int $datos id del usuario
*/
public function check_buy($buy){
    $consulta=$this->db->query("SELECT id_adviser FROM insurance_buy WHERE id_buy='$buy'");
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return ['status'=>false];
    }else{
    while($filas=$consulta->fetch_assoc()){
        $id_adviser=$filas['id_adviser'];
    }
    return ['status'=>true,'id'=>$id_adviser];
    }
}

/**
* Consulta de servicios.
*
* Consulta de servicios la consulta se hace por id*
*
* @return Array de  roles asignadas
* @param Int $datos id del usuario
*/
public function query_contract($id){
    $consulta=$this->db->query("SELECT description_contract FROM contracts WHERE id_contract='$id'");
    
    while($filas=$consulta->fetch_assoc()){
        $body=$filas['description_contract'];
    }
    return $body;
}

/**
* Consulta de archivos.
*
* Consulta de archivos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de archivos registrados
* @param Int $datos id del usuario
*/
public function query_files($perfil,$user){
    if ($perfil == "6") {
        $consulta=$this->db->query("SELECT CONCAT(a.name_adviser,' ',a.surname_adviser) as nombres,b.name_file as archivo FROM files as b INNER JOIN advisers as a ON (b.id_adviser=a.id_adviser) WHERE b.id_adviser='$user' AND b.type_file='1' ");
    }else{
        $consulta=$this->db->query("SELECT a.name_agency as nombres,b.name_file as archivo FROM files as b INNER JOIN agencies as a ON (b.id_agency=a.id_agency) WHERE b.id_agency='$user' AND b.type_file='1' ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}


}
?>