<?php
require_once('includes/definition.php');

class services_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_services($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_service as id,b.name_service as name,b.description_service as description,b.image_service as image,s.status_name as status,s.status_color as color FROM services as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_service as id,b.name_service as name,b.id_status as status,b.description_service as description,b.image_service as image FROM services as b WHERE b.id_service='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM services WHERE name_service='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM services WHERE name_service='$datos' AND id_service !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_service($name,$descripcion,$imagen,$user){
    $date=date('Y-m-d H:i:s');
    $name_archivo = str_replace(" ", "_", $name);
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $insert=$this->db->query("INSERT INTO services(name_service,description_service,image_service,id_user,create_date) VALUES ('$name','$descripcion','$name_image','$user','$date')");
    if ($insert) {
    $location=$_SESSION['ruta_img'].'services_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    }
    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_service($name,$descripcion,$imagen,$status,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE services SET name_service='$name',description_service='$descripcion',id_status='$status',id_user='$user',create_date='$date' WHERE id_service='$id'");
    $name_archivo = str_replace(" ", "_", $name);
    if (!is_null($imagen)) {
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $location=$_SESSION['ruta_img'].'services_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    $update=$this->db->query("UPDATE services SET image_service='$name_image' WHERE id_service='$id'");
    }
    return $update;
}
/**
* Chequear si service.
*
*Funcion para validar si service existe*
*
* @return Boolean  
* @param Int $id id de service
*/
public function check_service($id){
    $consulta=$this->db->query("SELECT 1 FROM services WHERE id_service='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_service($id){
    $delete=$this->db->query("DELETE FROM services WHERE id_service='$id'");
    return $delete;
}

}
?>