<?php
//Llamada al modelo
require 'model/faqs_model.php';

class faqs_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true]   
* @param Method POST String $pregunta Pregunta frecuente,String $resp respuesta de Pregunta frecuente,Int $status status de la Pregunta frecuente,Int $id id de Pregunta frecuente
*/
public function validate_faqs($pregunta,$resp,$status,$id){
	$per=new faqs_model();
	if (strlen($pregunta) > 300 || empty($pregunta)) {
		$datos = array('msg' => 'Pregunta no debe estar vacío ni exceder los 300 caracteres','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id)) {
		$valid=$per->check_faqs($id);
		if (!$valid) {
			$datos = array('msg' => 'Pregunta frecuente no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}
/**
* Consulta de faqs.
*
*Funcion para consultar faqs registrados para llenar tabla*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_faqs(){
	$per=new faqs_model();
	$datos=$per->query_faqs(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => 'T','datos' => $datos);
	return $datos1;
}

/**
* Registrar Pregunta frecuente.
*
*Funcion para Registrar Pregunta frecuente, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST String $pregunta Pregunta frecuente,String $resp respuesta de Pregunta frecuente,Int $status status de la Pregunta frecuente
*/
public function register_faqs(){
	$per=new faqs_model();
	$pregunta=$_POST['pregunta'];
	$resp=$_POST['resp'];
	$status=1;
	$valid=$this->validate_faqs($pregunta,$resp,$status,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_faqs($pregunta,$resp,$status);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de Pregunta frecuente.
*
*Funcion para consultar Pregunta frecuente registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de Pregunta frecuente
*/
public function view_faqs(){
	$var1=$_POST['id'];
	$per=new faqs_model();
	$datos=$per->query_faqs($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Pregunta no existe','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Editar Pregunta frecuente.
*
*Funcion para Editar Pregunta frecuente, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST String $pregunta Pregunta frecuente,String $resp respuesta de Pregunta frecuente,Int $status status de la Pregunta frecuente,Int $id id de Pregunta frecuente
*/
public function edit_faqs(){
	$per=new faqs_model();
	$pregunta=$_POST['pregunta'];
	$resp=$_POST['resp'];
	$status=$_POST['status'];
	$id=$_POST['id'];
	$valid=$this->validate_faqs($pregunta,$resp,$status,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_faqs($pregunta,$resp,$status,$id);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Elimimar Pregunta frecuente.
*
*Funcion para eliminar Pregunta frecuente, chequea si el Pregunta frecuente existe si arroja false elimina el Pregunta frecuente*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST Int $data1 id del Pregunta frecuente
*/
public function delete_faqs(){
	$per=new faqs_model();
	$data1=$_POST['id'];
	$valid=$per->check_faqs($data1);
	if (!$valid) {
		$datos = array('msg' => 'Pregunta frecuente no existe','status' => false,'code' => 400);
		return $datos;
	}
	$datos=$per->delete_faqs($data1);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
}
?>