<?php
//Llamada al modelo
require 'model/logos_model.php';

class logos_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_logos($imagen,$imagen1){
	if (!is_null($imagen)) {
		$ext = pathinfo($imagen['name'], PATHINFO_EXTENSION);
		if ($ext!=="png") {
			$datos = array('msg' => 'Error formato de imagen primario. Debe ser PNG','status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($imagen['tmp_name']);
		if ($tamaño[0]> 2000 || $tamaño[1] > 2000 || $imagen['size'] > 200000) {		
			$datos = array('msg' =>'Error, la imagen primario debe tener un ancho inferior a 2000px y una altura de 2000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($imagen1)) {
		$ext = pathinfo($imagen1['name'], PATHINFO_EXTENSION);
		if ($ext!=="png") {
			$datos = array('msg' => 'Error formato de imagen secundario.  Debe ser PNG','status' => false ,'code' => 400);
			return $datos;
		}
		$tamaño = getimagesize($imagen1['tmp_name']);
		if ($tamaño[0]> 2000 || $tamaño[1] > 2000 || $imagen1['size'] > 200000) {		
			$datos = array('msg' =>'Error, la imagen secundario debe tener un ancho inferior a 2000px y una altura de 2000px.','status' => false ,'code' => 400);
			return $datos;
		}
	}
	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Consulta de empleados.
*
*Funcion para consultar empleados registrados para llenar input*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param 
*/
public function query_logos(){
	$per=new logos_model();
	$datos=$per->query_logos(NULL);
	$datos1 = array('msg' => $_SESSION['lang']['TABLA'],'status' => true,'datos' => $datos);
	return $datos1;
}
/**
* Editar empleados.
*
*Funcion para Registrar empleado, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_logos(){
	$per=new logos_model();
	$imagen=$_FILES['imagen'];
	$imagen1=$_FILES['imagen1'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_logos($imagen,$imagen1);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_logos($imagen,$imagen1,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'datos' => $datos,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;

	}

}

}
?>