<?php
//Llamada al modelo
require 'model/prices_model.php';
require 'model/insurances_model.php';

class prices_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_price($precio,$id_insurance,$id){
	$per=new prices_model();
	$per1=new insurances_model();

	if (empty($precio) || $precio < 1) {
		$datos = array('msg' => 'Error! Campo precio','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id_insurance)) {
		$valid=$per1->check_insurance($id_insurance);
		if (!$valid) {
			$datos = array('msg' => 'Formulario no existe','status' => false ,'code' => 400);
			return $datos;
		}}
		if (!is_null($id)) {
			$valid=$per->check_price($id);
			if (!$valid) {
				$datos = array('msg' => 'Item no existe','status' => false ,'code' => 400);
				return $datos;
			}
		}
		$datos = array('msg' => 'GOOD','status' =>true);
		return $datos;
	}
/**
* Vista de formularios.
*
*Funcion para consultar formularios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de formularios
*/
public function query_prices(){
	$var1=$_POST['id'];
	$per=new prices_model();
	$datos=$per->query_prices($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Formulario no posee montos agregados','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Registrar precio.
*
*Funcion para Registrar precio, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_price(){
	$per=new prices_model();
	$precio=str_replace('.','',$_POST['precio']);
	$precio=str_replace(',','.', $precio);
	$id=$_POST['id'];
	$descripcion=$_POST['descripcion'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_price($precio,$id,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_price($precio,$descripcion,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Vista de formularios.
*
*Funcion para consultar formularios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de formularios
*/
public function query_descripcion(){
	$var1=$_POST['id'];
	$per=new prices_model();
	$datos=$per->query_descripcion($var1);
	$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	return $datos1;
}
/**
* Registrar precio.
*
*Funcion para Registrar precio, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_price(){
	$per=new prices_model();
	$precio=str_replace('.','',$_POST['precio']);
	$precio=str_replace(',','.', $precio);
	$id=$_POST['id'];
	$user=$_SESSION['bn_user_global'];
	$descripcion=$_POST['descripcion'];

	$valid=$this->validate_price($precio,NULL,$id);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_price($precio,$descripcion,$id,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Elimimar precio.
*
*Funcion para eliminar precio, chequea si el precio existe si arroja true elimina el precio*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_price(){
	$per=new prices_model();
	$data1=$_POST['id'];
	$valid=$per->check_price($data1,NULL);
	if (!$valid) {
		$datos = array('msg' => 'Precio no existe','status' => false,'code' => 400);
		return $datos;
	}
	$opcion=1;
	$user=$_SESSION['bn_user_global'];

	/*$valid=$per->check_game($data1);
	if (!$valid) {
		$datos = array('msg' => 'Formulario tiene juego asociado, solo se puede desactivar','status' => false,'code' => 400);
		return $datos;
	}*/
	$datos=$per->delete_price($data1,$opcion,$user);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}

/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_age_groups($id,$grupo,$puntos,$sumas,$id_group){
	$per=new insurances_model();
	$per1=new prices_model();

	$valid=$per1->check_group($grupo);
	if (!$valid) {
		$datos = array('msg' => 'Grupo etario no existe','status' => false ,'code' => 400);
		return $datos;
	}

	if (!is_numeric($puntos) || $puntos > 100) {
		$datos = array('msg' => 'Puntos invalido','status' => false ,'code' => 400);
		return $datos;
	}


	if (!is_null($sumas)) {
	if (!is_array($sumas) || count($sumas) < 1) {
		$datos = array('msg' => 'Sumas aseguradas no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($sumas as $value1) {
		$valid1=$per1->check_price($value1,$id);
		if (!$valid1) {
			$datos = array('msg' => 'Error! Suma asegurada no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}}
	$valid=$per->check_insurance($id);
	if (!$valid) {
		$datos = array('msg' => 'Formulario no existe','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id_group)) {
		$valid=$per1->check_age_groups($id_group,$id);
		if (!$valid) {
			$datos = array('msg' => 'Grupo etario no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}

	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;
}

/**
* Vista de formularios.
*
*Funcion para consultar formularios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de formularios
*/
public function query_age_groups(){
	$var1=$_POST['id'];
	$per=new prices_model();
	$datos=$per->query_age_groups($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'No posee agregados','status' => false,'code' => 400);
	}
	return $datos1;
}

/**
* Registrar grupo etario.
*
*Funcion para Registrar grupo etario, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_age_groups(){
	$per=new prices_model();
	$id=$_POST['id'];
	$grupo=$_POST['grupo'];
	$puntos=$_POST['puntos'];
	$sumas=$_POST['sumas'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_age_groups($id,$grupo,$puntos,$sumas,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_age_groups($grupo,$puntos,$sumas,$user);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

/**
* Editar ajustes.
*
*Funcion para Registrar ajustes, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function edit_age_groups(){
	$per=new prices_model();
	$id=$_POST['id'];
	$grupo=$_POST['grupo'];
	$puntos=$_POST['puntos'];
	$id_group=$_POST['id_group'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_age_groups($id,$grupo,$puntos,NULL,$id_group);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->edit_age_groups($grupo,$puntos,$id_group,$user);
		$resp1 = array('msg' => $_SESSION['lang']['EDITADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}

/**
* Elimimar ajuste.
*
*Funcion para eliminar ajuste, chequea si el ajuste existe si arroja true elimina el ajuste*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_age_groups(){
	$per=new prices_model();
	$data1=$_POST['id'];
	$data2=$_POST['data2'];

	$valid=$per->check_age_groups($data1,$data2);
	if (!$valid) {
		$datos = array('msg' => 'Grupo etario no existe','status' => false,'code' => 400);
		return $datos;
	}
	$opcion=1;
	$user=$_SESSION['bn_user_global'];
	$datos=$per->delete_age_groups($data1,1,$user);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}


}
?>