<?php
//Llamada al modelo
require 'model/terms_model.php';
require 'model/insurances_model.php';

class terms_controller
{
/**
* Validar entrada de datos.
*
*Funcion para validar entrada de datos antes de ir a la funcion de insercion o edicion. Chequeo de longitud de valores,tipo de datos,duplicidad de datos,existencia*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true] 
* @param Method POST 
*/
public function validate_term($coberturas,$monto_condicion,$opcion_term,$condicion_term,$result_term,$id_insurance,$general,$paises,$id){

    require 'model/countries_model.php';
	$per=new terms_model();
	$per1=new insurances_model();
	$per2=new countries_model();

	$opcion_valid=['1','2','3'];
	$condicion_valid=['1','2','3','4','5','6'];
	if (!is_numeric($monto_condicion) || empty($monto_condicion) || $monto_condicion < 1) {
		$datos = array('msg' => 'Monto invalido','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_array($opcion_term) || count($opcion_term) == 0) {
		$datos = array('msg' => 'Opcion no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	$i=0;
	foreach ($opcion_term as $value) {
		if (!in_array($value, $opcion_valid)) {
			$datos = array('msg' => 'Error! Opcion invalida','status' => false ,'code' => 400);
			return $datos;
		}
		if ($value == "1") {
			if (!is_numeric($result_term[$i])) {
				$datos = array('msg' => 'Error! Edad debe ser formato numerico','status' => false ,'code' => 400);
				return $datos;
			}
		}
		$i++;
	}
	if (!is_array($condicion_term) || count($condicion_term) == 0) {
		$datos = array('msg' => 'Condicion no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($condicion_term as $value) {
		if (!in_array($value, $condicion_valid)) {
			$datos = array('msg' => 'Error! Condicion invalida','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_array($result_term) || count($result_term) == 0) {
		$datos = array('msg' => 'Respuesta no debe estar vacío ','status' => false ,'code' => 400);
		return $datos;
	}
	foreach ($result_term as $value) {
		if (strlen($value) > 10 || empty($value)) {
			$datos = array('msg' => 'Error! Respuesta no debe estar vacío','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (count($opcion_term) != count($result_term) || count($opcion_term) != count($condicion_term) || count($result_term) != count($condicion_term)) {
		$datos = array('msg' => 'Error! Data invalida ','status' => false ,'code' => 400);
		return $datos;
	}
	if (!is_null($id_insurance)) {
		$valid=$per1->check_insurance($id_insurance);
		if (!$valid) {
			$datos = array('msg' => 'Formulario no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}
	if (!is_null($id)) {
		$valid=$per->check_term($id);
		if (!$valid) {
			$datos = array('msg' => 'Condicion no existe','status' => false ,'code' => 400);
			return $datos;
		}
	}

	if ($general == "1") {
		if (!is_array($paises) || count($paises) == 0) {
			$datos = array('msg' => 'Paises no debe estar vacío ','status' => false ,'code' => 400);
			return $datos;
		}
		foreach ($paises as $value) {
		$valid=$per2->check_country_active($value);
		if (!$valid) {
			$datos = array('msg' => 'Pais no existe','status' => false ,'code' => 400);
			return $datos;
		}
		}
	}

	$datos = array('msg' => 'GOOD','status' =>true);
	return $datos;

}
/**
* Vista de formularios.
*
*Funcion para consultar formularios registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de formularios
*/
public function query_terms(){
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new terms_model();
	$datos=$per->query_terms($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'form' => $option[2],'code' => 200);
	}else{
		$datos1 = array('msg' => 'Formulario no posee tarifas agregados','status' => false,'code' => 400,'form' => $option[2]);
	}
	return $datos1;
}
/**
* Vista de sumas asegurada.
*
*Funcion para consultar sumas asegurada registrado por id asi mostrar informacion para editar*
*
* @return Array msg=mensaje,status,datos=array de la consulta 
* @param Method POST Int $var1 id de sumas asegurada
*/
public function query_prices(){
	require 'model/prices_model.php';
	$var1=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($var1);
	$option=explode('/',trim($option));
	$var1=$option[1];
	$per=new prices_model();
	$datos=$per->query_prices($var1);
	if (count($datos) > 0) {
		$datos1 = array('msg' => $_SESSION['lang']['SELECCION'],'status' => true,'datos' => $datos,'code' => 200);
	}else{
		$datos1 = array('msg' => 'Formulario no posee montos agregados','status' => false,'code' => 400);
	}
	return $datos1;
}
/**
* Registrar condicion.
*
*Funcion para Registrar condicion, primero se envia a depurar la informacion ingresada y luego se inserta*
*
* @return Array msg=mensaje,status,datos=boolean 
* @param Method POST 
*/
public function register_term(){
	$per=new terms_model();
	$id=$_POST['id'];
	$decryp=new routehelper();
	$option=$decryp->decryptroute($id);
	$option=explode('/',trim($option));
	$id=$option[1];
	$monto_condicion=str_replace('.','',$_POST['monto_condicion']);
	$monto_condicion=str_replace(',','.', $monto_condicion);
	$coberturas=$_POST['coberturas'];
	$opcion_term=$_POST['opcion_term'];
	$condicion_term=$_POST['condicion_term'];
	$result_term=$_POST['result_term'];
	$paises=$_POST['paises'];
	$general=$_POST['general'];
	$user=$_SESSION['bn_user_global'];
	$valid=$this->validate_term($coberturas,$monto_condicion,$opcion_term,$condicion_term,$result_term,$id,$general,$paises,NULL);
	if (!$valid['status']) {
		return $valid;
	}else{
		$datos=$per->register_term($coberturas,$monto_condicion,$opcion_term,$condicion_term,$result_term,$id,$user,$general,$paises);
		$resp1 = array('msg' => $_SESSION['lang']['REGISTRADO'],'status' => true,'code' => 201);
		$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400);
		$return= (!$datos) ? $resp2 : $resp1;
		return $return;
	}
}
/**
* Elimimar condicion.
*
*Funcion para eliminar condicion, chequea si el condicion existe si arroja true elimina el condicion*
*
* @return Array msg=mensaje,status,datos=boolean 
*/
public function delete_term(){
	$per=new terms_model();
	$data1=$_POST['id'];
	$valid=$per->check_term($data1);
	if (!$valid) {
		$datos = array('msg' => 'Condicion no existe','status' => false,'code' => 400);
		return $datos;
	}
	$opcion=1;
	$user=$_SESSION['bn_user_global'];
	$valid=$per->check_pay($data1);
	if (!$valid) {
		$opcion=2;
	}
	$datos=$per->delete_term($data1,$opcion,$user);
	$resp1 = array('msg' => $_SESSION['lang']['ELIMINAR'],'status' => true,'datos' => $datos,'code' => 200);
	$resp2=array('msg' => $_SESSION['lang']['ERROR_INSERT'],'status' => false,'code' => 400,'opcion' => $opcion);
	$return= (!$datos) ? $resp2 : $resp1;
	return $return;
}
}
?>