<?php
require_once('includes/definition.php');

class blogs_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de blog.
*
* Consulta de blog registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de blog registrados
* @param Int $datos id del usuario
*/
public function query_blogs($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_blog as id,b.title_blog as name,DATE_FORMAT(b.create_date, '%Y-%m-%d') as date_blog,s.status_name as status,s.status_color as color FROM blogs as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_blog as id,b.title_blog as name,b.id_status as status,b.description_blog as description,b.alt_img as alt,b.coverpage_blog as image FROM blogs as b WHERE b.id_blog='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Detalle de blog.
*
* Detalle de blog registrados en caso de recibir parametro not null la Detalle se hace por id*
*
* @return Array de blog registrados
* @param Int $datos id del usuario
*/
public function details_blogs($datos){
    $consulta=$this->db->query("SELECT b.id_blog as id,b.title_blog as name,b.description_blog as descripcion,DATE_FORMAT(b.create_date, '%Y-%m-%d') as date_blog,b.alt_img as alt,b.coverpage_blog as image,s.status_name as status,s.status_color as color FROM blogs as b INNER JOIN status as s ON (b.id_status=s.id_status) WHERE b.id_blog='$datos' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de categorias.
*
* Consulta de categorias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de categorias registrados
* @param Int $datos id del usuario
*/
public function query_categories($datos){
    if (is_null($datos)) {   
    $consulta=$this->db->query("SELECT b.id_category as id,b.name_category as name FROM categories as b WHERE b.id_status=1 ");
    }else{
    $consulta=$this->db->query("SELECT b.id_category as id,b.name_category as name FROM categories as b WHERE b.id_status=1 AND b.id_category='$datos'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Validar de categorias.
*
* Validar de categorias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de categorias registrados
* @param Int $datos id del usuario
*/
public function check_categories($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
    $consulta=$this->db->query("SELECT b.id_category as id FROM blog_categories as b WHERE b.id_blog='$datos' ");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas['id'];
    }
    }else{
    $consulta=$this->db->query("SELECT b.id_category as id, c.name_category as name FROM blog_categories as b INNER JOIN categories as c ON (b.id_category=c.id_category) WHERE b.id_blog='$datos' ");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    }
    return $query;
}
/**
* Consulta de etiqueta.
*
* Consulta de etiqueta registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de etiqueta registrados
* @param Int $datos id del usuario
*/
public function query_tags($datos){
    if (is_null($datos)) {   
    $consulta=$this->db->query("SELECT b.id_tag as id,b.name_tag as name FROM tags as b WHERE b.id_status=1 ");
    }else{
    $consulta=$this->db->query("SELECT b.id_tag as id,b.name_tag as name FROM tags as b WHERE b.id_status=1 AND b.id_tag='$datos'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Validar de etiqueta.
*
* Validar de etiqueta registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de etiqueta registrados
* @param Int $datos id del usuario
*/
public function check_tags($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
    $consulta=$this->db->query("SELECT b.id_tag as id FROM blog_tags as b WHERE b.id_blog='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas['id'];
    }
    }else{
    $consulta=$this->db->query("SELECT b.id_tag as id, c.name_tag as name FROM blog_tags as b INNER JOIN tags as c ON (b.id_tag=c.id_tag) WHERE b.id_blog='$datos' ");

    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    }
    return $query;
}
/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM blogs WHERE title_blog='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM blogs WHERE title_blog='$datos' AND id_blog !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_blog($name,$categorias,$etiquetas,$descripcion,$imagen,$alt_imagen,$user){
    $date=date('Y-m-d H:i:s');
    $descripcion = str_replace ("'", "&apos;",$descripcion);
    $insert=$this->db->query("INSERT INTO blogs(title_blog,description_blog,coverpage_blog,alt_img,id_user,create_date) VALUES ('$name','$descripcion','1','$alt_imagen','$user','$date')");
    if ($insert) {
    $id=$this->db->insert_id;
    foreach ($categorias as $value) {
    $insert=$this->db->query("INSERT INTO blog_categories(id_category,id_blog) VALUES ($value,$id)");
    }
    foreach ($etiquetas as $value) {
    $insert=$this->db->query("INSERT INTO blog_tags(id_tag,id_blog) VALUES ($value,$id)");
    }

    $name_archivo = 'Blog_'.$id;
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $insert=$this->db->query("UPDATE blogs SET coverpage_blog='$name_image' WHERE id_blog='$id'");

    $location=$_SESSION['ruta_img'].'blog_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);

    }
    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_blog($name,$agregar_s,$eliminar_s,$agregar_p,$eliminar_p,$descripcion,$imagen,$alt_imagen,$status,$id,$user){
    $date=date('Y-m-d H:i:s');
    if (count($eliminar_s) > 0) {
        foreach ($eliminar_s as $e_emp) {
            $dato1=$this->db->query("DELETE FROM blog_categories WHERE id_category='$e_emp' AND id_blog='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_s) > 0) {
        foreach ($agregar_s as $a_emp) {
            $dato2=$this->db->query("INSERT INTO blog_categories(id_blog,id_category) VALUES ('$id','$a_emp')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }
    if (count($eliminar_p) > 0) {
        foreach ($eliminar_p as $e_emp) {
            $dato1=$this->db->query("DELETE FROM blog_tags WHERE id_tag='$e_emp' AND id_blog='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_p) > 0) {
        foreach ($agregar_p as $a_emp) {
            $dato2=$this->db->query("INSERT INTO blog_tags(id_blog,id_tag) VALUES ('$id','$a_emp')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }
    $descripcion = str_replace ("'", "&apos;",$descripcion);

    $update=$this->db->query("UPDATE blogs SET title_blog='$name',description_blog='$descripcion',alt_img='$alt_imagen',id_status='$status',id_user='$user',create_date='$date' WHERE id_blog='$id'");

    $name_archivo = 'Blog_'.$id;
    if (!is_null($imagen)) {
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $location=$_SESSION['ruta_img'].'blog_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    $update=$this->db->query("UPDATE blogs SET coverpage_blog='$name_image' WHERE id_blog='$id'");
    }

    return $update;
}
/**
* Chequear si blog.
*
*Funcion para validar si blog existe*
*
* @return Boolean  
* @param Int $id id de blog
*/
public function check_blog($id){
    $consulta=$this->db->query("SELECT 1 FROM blogs WHERE id_blog='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_blog($id){
    $delete=$this->db->query("DELETE FROM blogs WHERE id_blog='$id'");
    return $delete;
}

}
?>