<?php
require_once('includes/definition.php');

class contracts_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_contracts($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_contract as id,b.name_contract as name,s.status_name as status,s.status_color as color FROM contracts as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_contract as id,b.name_contract as name,b.id_status as status,b.description_contract as descripcion FROM contracts as b WHERE b.id_contract='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM contracts WHERE name_contract='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM contracts WHERE name_contract='$datos' AND id_contract !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_contract($name,$descripcion,$status,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO contracts(name_contract,description_contract,id_status,id_user,create_date) VALUES ('$name','$descripcion','$status','$user','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_contract($name,$descripcion,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE contracts SET name_contract='$name',description_contract='$descripcion',id_status='$status',id_user='$user',create_date='$date' WHERE id_contract='$id'");
    return $update;
}
/**
* Chequear si contract.
*
*Funcion para validar si contract existe*
*
* @return Boolean  
* @param Int $id id de contract
*/
public function check_contract($id){
    $consulta=$this->db->query("SELECT 1 FROM contracts WHERE id_contract='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_blog($id){
    $consulta=$this->db->query("SELECT 1 FROM blog_contracts WHERE id_contract='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_contract($id){
    $delete=$this->db->query("DELETE FROM contracts WHERE id_contract='$id'");
    return $delete;
}

/**
* Consulta de archivos.
*
* Consulta de archivos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de archivos registrados
* @param Int $datos id del usuario
*/
public function query_files(){
    if (empty($_SESSION['bn_user_global_agencias']) || is_null($_SESSION['bn_user_global_agencias'])) {
        $id_adviser=$_SESSION['bn_user_global_advisers']; 
        $consulta=$this->db->query("SELECT b.id_file as id,b.type_file as tipo,b.name_file as archivo FROM files as b WHERE b.id_adviser='$id_adviser' ");
    }else{
        $id_agency=$_SESSION['bn_user_global_agencias'];

        $consulta=$this->db->query("SELECT b.id_file as id,b.type_file as tipo,b.name_file as archivo FROM files as b WHERE b.id_agency='$id_agency'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_file ($opcion_file){
    if (empty($_SESSION['bn_user_global_agencias']) || is_null($_SESSION['bn_user_global_agencias'])) {
    $id=$_SESSION['bn_user_global_advisers']; 
    $consulta=$this->db->query("SELECT 1 FROM files WHERE id_adviser='$id' AND type_file='$opcion_file' AND id_status='11'");
    }else{
    $id=$_SESSION['bn_user_global_agencias']; 
    $consulta=$this->db->query("SELECT 1 FROM files WHERE id_agency='$id' AND type_file='$opcion_file' AND id_status='11'");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}



/**
* Registrar archivo.
*
*Funcion para registrar archivo*
*
* @return Boolean  
*/
public function register_file($opcion_file,$archivo){
    $date=date('Y-m-d H:i:s');
    $ext_img = pathinfo($archivo['name'], PATHINFO_EXTENSION);
    if (empty($_SESSION['bn_user_global_agencias']) || is_null($_SESSION['bn_user_global_agencias'])) {
    $id_agency='NULL';  
    $id_adviser=$_SESSION['bn_user_global_advisers']; 
    if ($opcion_file == "1") {
    $name_file='digital_signatureag'.$id_adviser.'.'.$ext_img;
    }else{
    $name_file='file_wag'.$id_adviser.'.'.$ext_img;
    } 

    $delete=$this->db->query("DELETE FROM files WHERE id_adviser='$id_adviser' AND type_file='$opcion_file' ");
    }else{
    $id_adviser='NULL';  
    $id_agency=$_SESSION['bn_user_global_agencias'];
    if ($opcion_file == "1") {
    $name_file='digital_signaturea'.$id_agency.'.'.$ext_img;
    }else{
    $name_file='file_wa'.$id_agency.'.'.$ext_img;
    }  

    $delete=$this->db->query("DELETE FROM files WHERE id_agency='$id_agency' AND type_file='$opcion_file' ");
    }

    $insert=$this->db->query("INSERT INTO files(id_agency,id_adviser,type_file,name_file,create_date) VALUES ($id_agency,$id_adviser,'$opcion_file','$name_file','$date')");

    if ($insert) {
    $id=$this->db->insert_id;
    $location=$_SESSION['ruta_img'].'files_kyc/'.$name_file;
    move_uploaded_file($archivo['tmp_name'],$location);
    }

    return $insert;
}



}
?>