<?php
require_once('includes/definition.php');

class events_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_events($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_event as id,b.name_event as name,p.name_product as producto,s.status_name as status,s.status_color as color FROM events as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN products as p ON (b.id_product=p.id_product) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_event as id,b.name_event as name,b.id_product as producto,b.id_status as status FROM events as b WHERE b.id_event='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM events WHERE name_event='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM events WHERE name_event='$datos' AND id_event !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Consulta de formularios.
*
* Consulta de formularios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de formularios registrados
* @param Int $datos id del usuario
*/
public function query_products($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_product as id,b.name_product as name FROM products as b ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_product='$datos' ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_event($name,$producto,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO events(name_event, id_product,id_user,create_date) VALUES ('$name','$producto','$user','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_event($name,$producto,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE events SET name_event='$name',id_product='$producto',id_status='$status',id_user='$user',create_date='$date' WHERE id_event='$id'");
    return $update;
}
/**
* Chequear si event.
*
*Funcion para validar si event existe*
*
* @return Boolean  
* @param Int $id id de event
*/
public function check_event($id){
    $consulta=$this->db->query("SELECT 1 FROM events WHERE id_event='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_blog($id){
    $consulta=$this->db->query("SELECT 1 FROM blog_events WHERE id_event='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_event($id){
    $delete=$this->db->query("DELETE FROM events WHERE id_event='$id'");
    return $delete;
}

}
?>