<?php
require_once('includes/definition.php');

class faqs_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion1();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de pregunta frecuente.
*
* Consulta de pregunta frecuente registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de pregunta frecuente registrados
* @param Int $datos id del usuario
*/
public function query_faqs($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_faq as id,b.question as pregunta,b.reply as respuesta,s.status_name as status,s.status_color as color FROM faqs as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_faq as id,b.question as pregunta,b.reply as respuesta, b.id_status as status FROM faqs as b WHERE b.id_faq='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Registrar pregunta frecuente.
*
*Funcion para registrar pregunta frecuente*
*
* @return Boolean  
* @param Method POST String $pregunta Pregunta frecuente,String $resp respuesta de Pregunta frecuente,Int $status status de la Pregunta frecuente
*/
public function register_faqs($pregunta,$resp,$status){
    $insert=$this->db->query("INSERT INTO faqs(question,reply,id_status) VALUES ('$pregunta','$resp','$status')");
    return $insert;
}
/**
* Editar pregunta frecuente.
*
*Funcion para editar pregunta frecuente*
*
* @return Boolean  
* @param Method POST String $pregunta Pregunta frecuente,String $resp respuesta de Pregunta frecuente,Int $status status de la Pregunta frecuente,Int $id id de Pregunta frecuente
*/
public function edit_faqs($pregunta,$resp,$status,$id){
    $update=$this->db->query("UPDATE faqs SET question='$pregunta',reply='$resp',id_status='$status' WHERE id_faq='$id'");
    return $update;
}
/**
* Chequear si pregunta frecuente.
*
*Funcion para validar si pregunta frecuente existe*
*
* @return Boolean  
* @param Int $id id de pregunta frecuente
*/
public function check_faqs($id){
    $consulta=$this->db->query("SELECT 1 FROM faqs WHERE id_faq='$id' ");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}

/**
* Eliminar pregunta frecuente.
*
*Funcion para eliminar pregunta frecuente*
*
* @return Boolean  
* @param Int $id id de pregunta frecuente
*/
public function delete_faqs($id){
    $delete=$this->db->query("DELETE FROM faqs WHERE id_faq='$id'");
    return $delete;
}

}
?>