<?php
require_once('includes/definition.php');

class incidents_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_incidents($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_incident as id,b.n_identification as identificacion,IF(b.option_identification = 1, 'N°-Poliza', 'Identificacion') as opcion,b.date_incident as fecha_incidente,DATE_FORMAT(b.create_date, '%Y-%m-%d %h:%i %p') as fecha_creacion,e.name_event as evento,p.name_product as producto,b.names_user as name_user,b.surnames_user as ape_user,b.email_user as email_user,b.phone_user as tlf_user,b.identification_user as identificacion_user,s.status_name as status,s.status_color as color,b.id_status as ids FROM incident_service as b INNER JOIN events as e ON (b.id_event=e.id_event) INNER JOIN products as p ON (e.id_product=p.id_product) INNER JOIN status as s ON (b.id_status=s.id_status) ORDER BY b.create_date DESC ");
    }else{
        $consulta=$this->db->query("SELECT b.id_incident as id,b.n_identification as identificacion,b.description_incident as descripcion,IF(b.option_identification = 1, 'N°-Poliza', 'Identificacion') as opcion,b.date_incident as fecha_incidente,DATE_FORMAT(b.create_date, '%Y-%m-%d %h:%i %p') as fecha_creacion,e.name_event as evento,p.name_product as producto,b.names_user as name_user,b.surnames_user as ape_user,b.email_user as email_user,b.phone_user as tlf_user,b.identification_user as identificacion_user FROM incident_service as b INNER JOIN events as e ON (b.id_event=e.id_event) INNER JOIN products as p ON (e.id_product=p.id_product) WHERE b.id_incident='$datos' ");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Chequear si incident.
*
*Funcion para validar si incident existe*
*
* @return Boolean  
* @param Int $id id de incident
*/
public function check_id($id){
    $consulta=$this->db->query("SELECT 1 FROM incident_service WHERE id_incident='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_files($datos){
    $consulta=$this->db->query("SELECT b.name_file as name,b.extension_file as ext FROM incident_files as b WHERE b.id_incident='$datos'  ");
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Editar incident.
*
*Funcion para editar incident*
*
* @return Boolean  
*/
public function edit_incident($id,$status,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE incident_service SET id_status='$status',id_user='$user',modify_date='$date' WHERE id_incident='$id'");
    return $update;
}


}
?>