<?php
require_once('includes/definition.php');

class insurances_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de formularios.
*
* Consulta de formularios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de formularios registrados
* @param Int $datos id del usuario
*/
public function query_insurances($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_insurance as id,b.name_insurance as name,b.title_pdf,b.description_insurance as descripcion,s.status_name as status,s.status_color as color FROM insurances as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_insurance as id,b.name_insurance as name,b.title_pdf,b.description_insurance as descripcion,b.id_status as status FROM insurances as b WHERE b.id_insurance='$datos' ");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de declaracion de salud.
*
* Consulta de declaracion de salud registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de declaracion de salud registrados
*/
public function insurances_declaration_health($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
    $consulta=$this->db->query("SELECT id_declaration_health as id_h FROM insurance_declaration_health as b WHERE b.id_insurance='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas['id_h'];
    }
    }else{
    $consulta=$this->db->query("SELECT id_declaration_health as id_h FROM insurance_declaration_health as b WHERE b.id_insurance='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    }
    return $query;
}
/**
* Consulta de declaracion de patologia.
*
* Consulta de declaracion de patologia registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de declaracion de patologia registrados
*/
public function insurances_declaration_pathology($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
    $consulta=$this->db->query("SELECT id_declaration_pathology as id_p FROM insurance_declaration_pathology as b WHERE b.id_insurance='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas['id_p'];
    }
    }else{
    $consulta=$this->db->query("SELECT id_declaration_pathology as id_p FROM insurance_declaration_pathology as b WHERE b.id_insurance='$datos'");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    }

    return $query;
}
/**
* Consulta de declaracion de salud.
*
* Consulta de declaracion de salud registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de declaracion de salud registrados
*/
public function query_declaration_health($datos){
    if (is_null($datos)) {   
    $consulta=$this->db->query("SELECT b.id_declaration_health as id,b.name_declaration_health as name FROM declaration_health as b WHERE b.id_status=1 ");
    }else{
    $consulta=$this->db->query("SELECT 1 FROM declaration_health as b WHERE b.id_status=1 AND b.id_declaration_health='$datos'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Consulta de declaracion de patologia.
*
* Consulta de declaracion de patologia registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de declaracion de patologia registrados
*/
public function query_declaration_pathology($datos){
    if (is_null($datos)) {   
    $consulta=$this->db->query("SELECT b.id_declaration_pathology as id,b.name_declaration_pathology as name FROM declaration_pathology as b WHERE b.id_status=1 ");
    }else{
    $consulta=$this->db->query("SELECT 1 FROM declaration_pathology as b WHERE b.id_status=1 AND b.id_declaration_pathology='$datos'");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Chequear si nombre de formulario existe.
*
*Funcion para consultar nombre de formulario registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de formulario,Int $id del formulario
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM insurances WHERE name_insurance='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM insurances WHERE name_insurance='$datos' AND id_insurance !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar formulario.
*
*Funcion para registrar formulario*
*
* @return Boolean  
*/
public function register_insurance($name,$title_pdf,$descripcion,$declaracion_s,$status,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO insurances(name_insurance,description_insurance,title_pdf,id_user,create_date) VALUES ('$name','$descripcion','$title_pdf','$user','$date')");
    if ($insert) {
    $id=$this->db->insert_id;
    foreach ($declaracion_s as $value) {
    $insert=$this->db->query("INSERT INTO insurance_declaration_health(id_insurance,id_declaration_health,id_user,create_date) VALUES ('$id','$value','$user','$date')");
    }
    }
    return $insert;
}
/**
* Editar formulario.
*
*Funcion para editar formulario*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la formulario,String $doc ruc de la formulario,String $direccion direccion de la formulario,Int $status status de la formulario,Int $data1 id de formulario
*/
public function edit_insurance($name,$title_pdf,$descripcion,$agregar_s,$eliminar_s,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    if (count($eliminar_s) > 0) {
        foreach ($eliminar_s as $e_emp) {
            $dato1=$this->db->query("DELETE FROM insurance_declaration_health WHERE id_declaration_health='$e_emp' AND id_insurance='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_s) > 0) {
        foreach ($agregar_s as $a_emp) {
            $dato2=$this->db->query("INSERT INTO insurance_declaration_health(id_insurance,id_declaration_health,id_user,create_date) VALUES ('$id','$a_emp','$user','$date')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }
    /*if (count($eliminar_p) > 0) {
        foreach ($eliminar_p as $e_emp) {
            $dato1=$this->db->query("DELETE FROM insurance_declaration_pathology WHERE id_declaration_pathology='$e_emp' AND id_insurance='$id'");
            if (!$dato1) {
                break;
                return false;
            }
        }
    }        
    if (count($agregar_p) > 0) {
        foreach ($agregar_p as $a_emp) {
            $dato2=$this->db->query("INSERT INTO insurance_declaration_pathology(id_insurance,id_declaration_pathology,id_user,create_date) VALUES ('$id','$a_emp','$user','$date')");
            if (!$dato2) {
                break;
                return false;
            }
        }
    }*/
    $update=$this->db->query("UPDATE insurances SET name_insurance='$name',title_pdf='$title_pdf',description_insurance='$descripcion',id_status='$status',id_user='$user',create_date='$date' WHERE id_insurance='$id'");
    return $update;
}
/**
* Chequear si insurance.
*
*Funcion para validar si insurance existe*
*
* @return Boolean  
* @param Int $id id de insurance
*/
public function check_insurance($id){
    $consulta=$this->db->query("SELECT 1 FROM insurances WHERE id_insurance='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si formulario  tiene usuarios asignados.
*
*Funcion para validar si formulario tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de formulario
*/
/*public function check_game($id){
    $consulta=$this->db->query("SELECT 1 FROM games WHERE id_place='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar formulario.
*
*Funcion para eliminar formulario*
*
* @return Boolean  
* @param Int $id id de formulario
*/
public function delete_insurance($id){
    $delete=$this->db->query("DELETE FROM insurances WHERE id_insurance='$id'");
    return $delete;
}
}
?>