<?php
require_once('includes/definition.php');

class issue_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_issue_advisers($asesor){
    $consulta=$this->db->query("SELECT b.id_buy as id,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha,b.user_id as identificador,b.email_user as email,pa.name_country as pais,p.name_product as producto,pago.total_payment as totalpago,p.id_product as producto_id FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN countries as pa ON (b.id_country=pa.iso) INNER JOIN insurance_payment as pago ON (b.id_buy=pago.id_buy) WHERE b.id_adviser='$asesor' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_comision($asesor,$producto){
    $consulta=$this->db->query("SELECT b.commission as comision FROM advisers_commissions as b WHERE b.id_product='$producto' AND b.id_adviser='$asesor' ");
    $comision=0;
    while($filas=$consulta->fetch_assoc()){
        $comision=$filas['comision'];
    }
    return $comision;
}
/**
* Consulta de prodcutos.
*
* Consulta de prodcutos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de prodcutos registrados
* @param Int $datos id del usuario
*/
public function query_product_advisers($asesor){
    $consulta=$this->db->query("SELECT p.id_insurance as id,p.name_product as producto,b.commission as comision FROM advisers_commissions as b INNER JOIN products as p ON (b.id_product=p.id_product) WHERE p.id_status='1' AND b.id_adviser='$asesor' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_issue_agencies($agencia){
    $consulta=$this->db->query("SELECT b.id_buy as id,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha,b.user_id as identificador,b.email_user as email,pa.name_country as pais,p.name_product as producto,pago.total_payment as totalpago,p.id_product as producto_id FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN countries as pa ON (b.id_country=pa.iso) INNER JOIN insurance_payment as pago ON (b.id_buy=pago.id_buy) WHERE b.id_agency='$agencia' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de comision.
*
* Consulta de comision registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de comision registrados
* @param Int $datos id del usuario
*/
public function query_comision_agencies($agencia,$producto){
    $consulta=$this->db->query("SELECT b.commission as comision FROM agencies_commissions as b WHERE b.id_product='$producto' AND b.id_agency='$agencia' ");
    $comision=0;
    while($filas=$consulta->fetch_assoc()){
        $comision=$filas['comision'];
    }
    return $comision;
}
/**
* Consulta de prodcutos.
*
* Consulta de prodcutos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de prodcutos registrados
* @param Int $datos id del usuario
*/
public function query_product_agencies($agencia){
    $consulta=$this->db->query("SELECT p.id_insurance as id,p.name_product as producto,b.commission as comision FROM agencies_commissions as b INNER JOIN products as p ON (b.id_product=p.id_product) WHERE p.id_status='1' AND b.id_agency='$agencia' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_issue_general($asesor){
    $consulta=$this->db->query("SELECT b.id_buy as id,lpad(b.id_buy , 6, 0) as poliza,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha,b.user_id as identificador,b.email_user as email,pa.name_country as pais,p.name_product as producto,pago.total_payment as totalpago,p.id_product as producto_id,CASE WHEN b.id_agency THEN 'Agencia' WHEN b.id_adviser THEN 'Asesor' WHEN b.id_agency_ibo THEN 'Agencia IBO' ELSE 'Web' END AS perfil,CONCAT(ad.name_adviser,' ',ad.surname_adviser) as nombre_asesor,CONCAT(ag.name_agency) as nombre_agencia,CONCAT(ag_ibo.name_agency,' Cod: ',b.ibo) as nombre_agenciaibo FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN countries as pa ON (b.id_country=pa.iso) INNER JOIN insurance_payment as pago ON (b.id_buy=pago.id_buy) LEFT JOIN advisers as ad ON (b.id_adviser=ad.id_adviser) LEFT JOIN agencies as ag ON (b.id_agency=ag.id_agency) LEFT JOIN agencies_ibo as ag_ibo ON (b.id_agency_ibo=ag_ibo.id_agency_ibo) ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_issue_detail($id){
    $consulta=$this->db->query("SELECT b.id_buy as id,lpad(b.id_buy , 6, 0) as poliza,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha,b.user_id as identificador,b.email_user as email,CONCAT(b.name_user,' ',b.last_name_user) as nombre_usuario,b.sex_user as sexo,b.date_birth as fecha_nac,b.smokes_user as fuma,b.phone_user as tlf,b.start_date as desde,b.end_date as hasta,pa.name_country as pais,p.name_product as producto,pri.price_insurance as cobertura,CASE WHEN b.id_agency THEN 'Agencia' WHEN b.id_adviser THEN 'Asesor' WHEN b.id_agency_ibo THEN 'Agencia IBO' ELSE 'Web' END AS perfil,b.ibo,CONCAT(ad.name_adviser,' ',ad.surname_adviser) as nombre_asesor,CONCAT(ag.name_agency) as nombre_agencia,lpad(ad.id_adviser , 6, 0) as code_ase,lpad(ag.id_agency , 6, 0) as code_age,pag.amount_term as term,pag.amount_coupon as monto_cupon,pag.sub_total_payment as subtotal,pag.total_payment as total,pag.discount as descuento,m.transid,m.accountnumber as tarjeta,m.accounttype as tipo_t,m.description_transaction as msg,ag_ibo.name_agency as agencia_ibo,pag.amount_tax as monto_tax,cu.code_coupon,cu.type_coupon FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN countries as pa ON (b.id_country=pa.iso) INNER JOIN insurance_prices as pri ON (b.id_price=pri.id_price) INNER JOIN insurance_payment as pag ON (b.id_buy=pag.id_buy) INNER JOIN payment_transactions as m ON (pag.id_transaction=m.id_transaction) LEFT JOIN insurance_coupons as cu ON (pag.id_coupon=cu.id_coupon) LEFT JOIN advisers as ad ON (b.id_adviser=ad.id_adviser) LEFT JOIN agencies as ag ON (b.id_agency=ag.id_agency) LEFT JOIN agencies_ibo as ag_ibo ON (b.id_agency_ibo=ag_ibo.id_agency_ibo) WHERE b.id_buy='$id' ");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_issue_total($fechai,$fechaf){


    if (is_null($fechai)) {   
    $consulta=$this->db->query("SELECT b.id_buy as id,lpad(b.id_buy , 6, 0) as poliza,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha,b.user_id as identificador,b.email_user as email,b.name_user as nombres,b.last_name_user as apellidos,b.start_date as date_d,b.end_date as date_h,b.id_agency,b.id_adviser,pa.name_country as pais,p.name_product as n_producto,pri.price_insurance as suma_asegurada,CASE WHEN b.id_agency THEN 'Agencia' WHEN b.id_adviser THEN 'Asesor' WHEN b.id_agency_ibo THEN 'Agencia IBO' ELSE 'Web' END AS perfil,b.ibo,CONCAT(ad.name_adviser,' ',ad.surname_adviser) as nombre_asesor,CONCAT(ag.name_agency) as nombre_agencia,lpad(ad.id_adviser , 6, 0) as code_ase,lpad(ag.id_agency , 6, 0) as code_age,ag.level_agency as level,pag.amount_term as term,pag.amount_coupon as monto_cupon,pag.sub_total_payment as subtotal,pag.total_payment as total,pag.discount as descuento,ag_ibo.name_agency as agencia_ibo,pag.amount_tax as monto_tax,cu.code_coupon,cu.type_coupon,p.id_product as producto FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN countries as pa ON (b.id_country=pa.iso) INNER JOIN insurance_prices as pri ON (b.id_price=pri.id_price) INNER JOIN insurance_payment as pag ON (b.id_buy=pag.id_buy) INNER JOIN payment_transactions as m ON (pag.id_transaction=m.id_transaction) LEFT JOIN insurance_coupons as cu ON (pag.id_coupon=cu.id_coupon) LEFT JOIN advisers as ad ON (b.id_adviser=ad.id_adviser) LEFT JOIN agencies as ag ON (b.id_agency=ag.id_agency) LEFT JOIN agencies_ibo as ag_ibo ON (b.id_agency_ibo=ag_ibo.id_agency_ibo)  ");

    }else{
    $consulta=$this->db->query("SELECT b.id_buy as id,lpad(b.id_buy , 6, 0) as poliza,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha,b.user_id as identificador,b.email_user as email,b.name_user as nombres,b.last_name_user as apellidos,b.start_date as date_d,b.end_date as date_h,b.id_agency,b.id_adviser,pa.name_country as pais,p.name_product as n_producto,pri.price_insurance as suma_asegurada,CASE WHEN b.id_agency THEN 'Agencia' WHEN b.id_adviser THEN 'Asesor' WHEN b.id_agency_ibo THEN 'Agencia IBO' ELSE 'Web' END AS perfil,b.ibo,CONCAT(ad.name_adviser,' ',ad.surname_adviser) as nombre_asesor,CONCAT(ag.name_agency) as nombre_agencia,lpad(ad.id_adviser , 6, 0) as code_ase,lpad(ag.id_agency , 6, 0) as code_age,ag.level_agency as level,pag.amount_term as term,pag.amount_coupon as monto_cupon,pag.sub_total_payment as subtotal,pag.total_payment as total,pag.discount as descuento,ag_ibo.name_agency as agencia_ibo,pag.amount_tax as monto_tax,cu.code_coupon,cu.type_coupon,p.id_product as producto FROM insurance_buy as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) INNER JOIN countries as pa ON (b.id_country=pa.iso) INNER JOIN insurance_prices as pri ON (b.id_price=pri.id_price) INNER JOIN insurance_payment as pag ON (b.id_buy=pag.id_buy) INNER JOIN payment_transactions as m ON (pag.id_transaction=m.id_transaction) LEFT JOIN insurance_coupons as cu ON (pag.id_coupon=cu.id_coupon) LEFT JOIN advisers as ad ON (b.id_adviser=ad.id_adviser) LEFT JOIN agencies as ag ON (b.id_agency=ag.id_agency) LEFT JOIN agencies_ibo as ag_ibo ON (b.id_agency_ibo=ag_ibo.id_agency_ibo) WHERE DATE_FORMAT(b.create_date, '%Y-%m-%d') BETWEEN '$fechai' AND '$fechaf' ");

    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_fhater($id,$opcion){
    if ($opcion == "1") {
    $consulta=$this->db->query("SELECT b.id_agency as agencia,ag.level_agency as level FROM advisers as b INNER JOIN agencies as ag ON (b.id_agency=ag.id_agency) WHERE b.id_adviser='$id' ");
    }else{
    $consulta=$this->db->query("SELECT ag.id_agency as agencia,ag.level_agency as level FROM agencies as b INNER JOIN agencies as ag ON (b.id_father=ag.id_agency) WHERE b.id_agency='$id' ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

}
?>