<?php
require_once('includes/definition.php');

class products_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/



public function query_products($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_product as id,f.name_insurance as formulario,b.name_product as name,b.price_product as precio,b.description_product as description,b.image_product as image,b.percentage_super_agency as superagencia,b.percentage_agencies_master as agencias_master,b.percentage_advisers as asesores,s.status_name as status,s.status_color as color,IF (b.option_web >1, 'Masivo','Web') as web FROM products as b INNER JOIN status as s ON (b.id_status=s.id_status) INNER JOIN insurances as f ON (b.id_insurance=f.id_insurance) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_product as id,b.id_insurance as id_formulario,f.name_insurance as formulario,b.name_product as name,b.id_status as status,b.description_product as description,b.price_product as precio,b.image_product as image,b.percentage_super_agency as superagencia,b.percentage_agencies_master as agencias_master,b.percentage_advisers as asesores,b.option_web as web FROM products as b INNER JOIN insurances as f ON (b.id_insurance=f.id_insurance) WHERE b.id_product='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de formularios.
*
* Consulta de formularios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de formularios registrados
* @param Int $datos id del usuario
*/
public function query_insurances($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_insurance as id,b.name_insurance as name FROM insurances as b WHERE b.id_status=1 ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM insurances as b WHERE b.id_insurance='$datos' AND b.id_status=1  ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Consulta de formularios.
*
* Consulta de formularios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de formularios registrados
* @param Int $datos id del usuario
*/
public function check_insurances($datos,$id){
    if (is_null($id)) {   
        $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_insurance='$datos' ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM products as b WHERE b.id_insurance='$datos' AND b.id_product!='$id'  ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Consulta de Archivos.
*
* Consulta de Archivos registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de Archivos registrados
*/
public function query_downloadable_files($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_file as id,b.title_file as name FROM downloadable_files as b WHERE b.id_status=1 ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM downloadable_files as b WHERE b.id_file='$datos' AND b.id_status=1 ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}
/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM products WHERE name_product='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM products WHERE name_product='$datos' AND id_product !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Validar de categorias.
*
* Validar de categorias registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de categorias registrados
* @param Int $datos id del usuario
*/
public function check_archivos($datos,$opcion){
    $query=[];
    if ($opcion == 1) {   
    $consulta=$this->db->query("SELECT b.id_file as id FROM products_files as b WHERE b.id_product='$datos' ");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas['id'];
    }
    }else{
    $consulta=$this->db->query("SELECT b.id_file as id, c.title_file as name, c.name_file as url FROM products_files as b INNER JOIN downloadable_files as c ON (b.id_file=c.id_file) WHERE b.id_product='$datos' ");
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    }
    return $query;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$superagencia,$agencias_master,$asesores,$web,$user){
    $date=date('Y-m-d H:i:s');
    $name_archivo = str_replace(" ", "_", $name);
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $insert=$this->db->query("INSERT INTO products(name_product,description_product,price_product,image_product,id_insurance,percentage_super_agency,percentage_agencies_master,percentage_advisers,option_web,id_user,create_date) VALUES ('$name','$descripcion','$precio','$name_image','$formulario','$superagencia','$agencias_master','$asesores','$web','$user','$date')");
    if ($insert) {
    $id=$this->db->insert_id;
    $insert=$this->db->query("INSERT INTO agencies_commissions(id_product,id_agency,commission) VALUES ($id,1,$superagencia)");

    foreach ($archivos as $value) {
    $insert=$this->db->query("INSERT INTO products_files(id_product,id_file) VALUES ($id,$value)");
    }
    $location=$_SESSION['ruta_img'].'products_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    }
    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_product($name,$precio,$descripcion,$imagen,$formulario,$archivos,$status,$superagencia,$agencias_master,$asesores,$web,$id,$user){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE products SET name_product='$name',description_product='$descripcion',price_product='$precio',id_insurance='$formulario',percentage_super_agency='$superagencia',percentage_agencies_master='$agencias_master',percentage_advisers='$asesores',id_status='$status',option_web='$web',id_user='$user',create_date='$date' WHERE id_product='$id'");
    if ($update) {
    $update=$this->db->query("UPDATE agencies_commissions SET commission='$superagencia' WHERE id_product='$id' AND id_agency='1' ");

    $update=$this->db->query("DELETE FROM products_files WHERE id_product='$id'");
    foreach ($archivos as $value) {
    $update=$this->db->query("INSERT INTO products_files(id_product,id_file) VALUES ($id,$value)");
    }
    $name_archivo = str_replace(" ", "_", $name);
    if (!is_null($imagen)) {
    $ext_img = pathinfo($imagen['name'], PATHINFO_EXTENSION);
    $name_image=$name_archivo.'.'.$ext_img;
    $location=$_SESSION['ruta_img'].'products_img/'.$name_image;
    move_uploaded_file($imagen['tmp_name'],$location);
    $update=$this->db->query("UPDATE products SET image_product='$name_image' WHERE id_product='$id'");
    }}
    return $update;
}
/**
* Chequear si product.
*
*Funcion para validar si product existe*
*
* @return Boolean  
* @param Int $id id de product
*/
public function check_product($id){
    $consulta=$this->db->query("SELECT 1 FROM products WHERE id_product='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_product($id){
    $delete=$this->db->query("DELETE FROM products WHERE id_product='$id'");
    return $delete;
}


}
?>