<?php
require_once('includes/definition.php');
require_once('includes/send_email.php');

class quoters_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;
    private $correo_1;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
        $this->correo_1= new emails();

    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_quoters($datos){

    $perfil=$_SESSION['bn_perfil'];
    $user=($perfil == "6") ? $_SESSION['bn_user_global_advisers'] : $_SESSION['bn_user_global_agencias'];

    if ($perfil == "6") {
    $consulta=$this->db->query("SELECT b.id_quoter as id,p.name_product as name_p,b.name_user as name,b.last_name_user as last,b.email_user as email,b.date_birth as fecha_nac,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha FROM quoters as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) WHERE b.id_adviser='$user' ");
    }else{
    $consulta=$this->db->query("SELECT b.id_quoter as id,p.name_product as name_p,b.name_user as name,b.last_name_user as last,b.email_user as email,b.date_birth as fecha_nac,DATE_FORMAT(b.create_date, '%Y-%m-%d') as fecha FROM quoters as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) WHERE b.id_agency='$user' ");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_price_product($datos){
    $consulta=$this->db->query("SELECT b.id_price as id,b.price_insurance as precio FROM insurance_prices as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) WHERE p.id_insurance='$datos' AND b.id_status='1' ORDER BY b.price_insurance ASC");
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function age_group($edad){
    $consulta=$this->db->query("SELECT id_group,start_age,end_age FROM age_groups WHERE id_status='1' ");
    $consulta2=$consulta->num_rows;
    while($filas=$consulta->fetch_assoc()){
        $inicio=$filas['start_age'];
        $final=$filas['end_age'];
        if ($edad >= $inicio && $edad <= $final) {
            $id_group=$filas['id_group'];
        }
    }
    return $id_group;
}
/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function sum_assured($producto,$grupo,$puntos,$plan){
    if (is_null($plan)) {
        $consulta=$this->db->query("SELECT p.id_price as id,p.price_insurance as precio,p.descripcion_price as descripcion FROM price_age_groups as b INNER JOIN insurance_prices as p ON (b.id_price=p.id_price) WHERE b.id_status='1' AND p.id_status='1' AND p.id_insurance='$producto' AND b.id_group='$grupo' AND b.points >='$puntos' ORDER BY p.price_insurance ASC ");
    }else{
        $consulta=$this->db->query("SELECT p.id_price as id,p.price_insurance as precio,p.descripcion_price as descripcion FROM price_age_groups as b INNER JOIN insurance_prices as p ON (b.id_price=p.id_price) WHERE b.id_status='1' AND p.id_status='1' AND p.id_insurance='$producto' AND b.id_group='$grupo' AND b.points >='$puntos' AND b.id_price='$plan' ");
    }
    $query=[];
    while($filas=$consulta->fetch_assoc()){
        $query[]=$filas;
    }
    return $query;
}

/**
* Validar de declaracion.
*
*
* @return Boolean
*/
public function query_price($plan,$edad,$pais){
    $consulta=$this->db->query("SELECT b.* FROM insurance_terms as b WHERE b.id_country IS NULL AND b.id_status='1' AND b.id_price='$plan'");

    $consulta1=$this->db->query("SELECT b.* FROM insurance_terms as b WHERE b.id_status='1' AND b.id_price='$plan' ANd b.id_country='$pais' ");

    $consulta2=$consulta->num_rows;
    $consulta3=$consulta1->num_rows;
    if ($consulta2 == 0 && $consulta3 == 0) {
        $datos = array('msg' => 'Producto no posee tarifas agregadas para este cliente','status' => false ,'code' => 400);
        return $datos;
    }else{
        $consulta=($consulta3 > 0) ? $consulta1 : $consulta;

        while($filas=$consulta->fetch_assoc()){
         $id_term=$filas['id_term'];
         $salida=$this->evaluate_condition($plan,$edad,$filas['description_term']);
         if ($salida) {
            $datos = array('msg' => 'Monto','status' => true ,'datos'=>$filas['amount_term'],'term'=>$id_term,'code' => 200);
         return $datos;
         }
        }
        $datos = array('msg' => 'Producto no posee tarifas agregadas para este cliente','status' => false,'code' => 400);
        return $datos;
    
    }
}
public function evaluate_condition($plan,$edad,$condicion){
        $cond="if(".$condicion."){
            return true ;
         }";
        $res=eval($cond);    
        return $res;
}
/**
* Validar de fecha.
*
*
* @return Boolean
*/
function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
/**
* Chequear si quoter.
*
*Funcion para validar si quoter existe*
*
* @return Boolean  
* @param Int $id id de quoter
*/
public function check_product($id,$user){
    $perfil=$_SESSION['bn_perfil'];
    if ($perfil == "6") {
    $consulta=$this->db->query("SELECT 1 FROM advisers_commissions as b INNER JOIN products as p ON (b.id_product=p.id_product) WHERE p.id_insurance='$id' AND b.id_adviser='$user' ");
    }else{
    $consulta=$this->db->query("SELECT 1 FROM agencies_commissions as b INNER JOIN products as p ON (b.id_product=p.id_product) WHERE p.id_insurance='$id' AND id_agency='$user' ");
    }
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si quoter.
*
*Funcion para validar si quoter existe*
*
* @return Boolean  
* @param Int $id id de quoter
*/
public function check_product_price($id,$product){
    $consulta=$this->db->query("SELECT 1 FROM insurance_prices as b INNER JOIN products as p ON (b.id_insurance=p.id_insurance) WHERE b.id_price='$id' AND p.id_product='$product'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si quoter.
*
*Funcion para validar si quoter existe*
*
* @return Boolean  
* @param Int $id id de quoter
*/
public function query_product($id){
    $consulta=$this->db->query("SELECT name_product FROM products WHERE id_insurance='$id' ");
    $name="";
    while($filas=$consulta->fetch_assoc()){
        $name=$filas['name_product'];
    }
    return $name;
}
/**
* Chequear si quoter.
*
*Funcion para validar si quoter existe*
*
* @return Boolean  
* @param Int $id id de quoter
*/
public function query_price_product1($id){
    $consulta=$this->db->query("SELECT b.price_insurance as precio FROM insurance_prices as b WHERE b.id_price='$id' AND b.id_status='1'");
    $precio="";
    while($filas=$consulta->fetch_assoc()){
        $precio=$filas['precio'];
    }
    return $precio;
}

/**
* Impuesto fumador.
*
*Funcion para Impuesto fumador*
*
* @return Boolean  
*/
public function smoker_taxes($formulario,$monto){
    $consulta=$this->db->query("SELECT id_smoker_tax,type_tax,amount_tax FROM smoker_taxes as b WHERE b.id_status='1' AND b.id_insurance='$formulario'");
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return ['id_tax'=>"NULL",'monto_tax'=>"0.00",'total'=>$monto];
    }else{
        while($filas=$consulta->fetch_assoc()){
            $tipo=$filas['type_tax'];
            $monto_tax=$filas['amount_tax'];
            $id=$filas['id_smoker_tax'];
        }
        if ($tipo == "1") {
            $monto_tax=($monto*$monto_tax)/100;
            $suma=$monto_tax+$monto;
        }else{
            $suma=$monto+$monto_tax;
        }
        return ['id_tax'=>$id,'monto_tax'=>$monto_tax,'total'=>$suma];
    }
}


/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_quoter($pais,$fuma,$producto,$name,$last_name,$email,$fecha_nac,$user,$html){
    $perfil=$_SESSION['bn_perfil'];
    $date=date('Y-m-d H:i:s');
    $user_adviser=($perfil == "6") ? "'$user'" : "NULL";
    $user_agencie=($perfil != "6") ? "'$user'" : "NULL";
    $insert=$this->db->query("INSERT INTO quoters(id_insurance,name_user,last_name_user,email_user,date_birth,id_adviser,id_agency,id_country,smoker,create_date) VALUES ('$producto','$name','$last_name','$email','$fecha_nac',$user_adviser,$user_agencie,'$pais','$fuma','$date')");
    if ($insert) {
        $id=$this->db->insert_id;
        $names=$name.' '.$last_name;
        $send=$this->correo_1->send_email($email,$names,'Cotización Bee Insurance',$html);
    }
    return $insert;
}

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_quoters_detail($datos){

    $perfil=$_SESSION['bn_perfil'];
    $user=($perfil == "6") ? $_SESSION['bn_user_global_advisers'] : $_SESSION['bn_user_global_agencias'];

    if ($perfil == "6") {

    $consulta=$this->db->query("SELECT b.id_quoter as id,b.name_user as name,b.last_name_user as last,b.email_user as email,b.date_birth as fecha_nac,b.id_insurance as formulario,b.id_country as pais,b.smoker as fuma FROM quoters as b WHERE b.id_adviser='$user' AND b.id_quoter='$datos' ");
    }else{
    $consulta=$this->db->query("SELECT b.id_quoter as id,b.name_user as name,b.last_name_user as last,b.email_user as email,b.date_birth as fecha_nac,b.id_insurance as formulario,b.id_country as pais,b.smoker as fuma FROM quoters as b WHERE b.id_agency='$user' AND b.id_quoter='$datos' ");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


}
?>