<?php
require_once('includes/definition.php');

class tags_model{
    private $db;
    private $query;
    private $validatename;
    private $validatename1;
    private $validatename2;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
    }

/**
* Consulta de empresas.
*
* Consulta de empresas registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de empresas registrados
* @param Int $datos id del usuario
*/
public function query_tags($datos){
    if (is_null($datos)) {   
        $consulta=$this->db->query("SELECT b.id_tag as id,b.name_tag as name,(SELECT COUNT(id_tag) FROM blog_tags WHERE id_tag=b.id_tag) as cantidad,s.status_name as status,s.status_color as color FROM tags as b INNER JOIN status as s ON (b.id_status=s.id_status) ");
    }else{
        $consulta=$this->db->query("SELECT b.id_tag as id,b.name_tag as name,b.id_status as status FROM tags as b WHERE b.id_tag='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}


/**
* Chequear si nombre de empresa existe.
*
*Funcion para consultar nombre de empresa registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de empresa,Int $id del empresa
*/
public function check_name ($datos,$id){
    $datos=trim($datos);
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM tags WHERE name_tag='$datos'");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM tags WHERE name_tag='$datos' AND id_tag !='$id' ");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
}
/**
* Registrar empresa.
*
*Funcion para registrar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa
*/
public function register_tag($name,$status,$user){
    $date=date('Y-m-d H:i:s');
    $insert=$this->db->query("INSERT INTO tags(name_tag, id_status,id_user,create_date) VALUES ('$name','$status','$user','$date')");

    return $insert;
}
/**
* Editar empresa.
*
*Funcion para editar empresa*
*
* @return Boolean  
* @param Method POST String $nombre nombre de la empresa,String $doc ruc de la empresa,String $direccion direccion de la empresa,Int $status status de la empresa,Int $data1 id de empresa
*/
public function edit_tag($name,$status,$user,$id){
    $date=date('Y-m-d H:i:s');
    $update=$this->db->query("UPDATE tags SET name_tag='$name',id_status='$status',id_user='$user',create_date='$date' WHERE id_tag='$id'");
    return $update;
}
/**
* Chequear si tag.
*
*Funcion para validar si tag existe*
*
* @return Boolean  
* @param Int $id id de tag
*/
public function check_tag($id){
    $consulta=$this->db->query("SELECT 1 FROM tags WHERE id_tag='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 == 0) {
        return false;
    }
    return true;
}
/**
* Chequear si empresa  tiene usuarios asignados.
*
*Funcion para validar si empresa tiene usuarios asigandos en el sistema de ser asi no se podra eliminar*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function check_blog($id){
    $consulta=$this->db->query("SELECT 1 FROM blog_tags WHERE id_tag='$id'");
    $consulta1=$consulta->num_rows;
    if ($consulta1 > 0) {
        return false;
    }
    return true;
}
/**
* Eliminar empresa.
*
*Funcion para eliminar empresa*
*
* @return Boolean  
* @param Int $id id de empresa
*/
public function delete_tag($id){
    $delete=$this->db->query("DELETE FROM tags WHERE id_tag='$id'");
    return $delete;
}

}
?>