<?php
require_once('includes/definition.php');

class users_model{
    private $db;
    private $query;
    private $profile;
    private $validatename;
    private $validatename1;
    private $validatename2;
    private $validatename3;

    public function __construct(){
        $this->db=Conectar::conexion();
        $this->query=array();
        $this->profile=array();
        $this->validatename=array();
        $this->validatename1=array();
        $this->validatename2=array();
        $this->validatename3=array();

    }

/**
* Consulta de usuarios.
*
* Consulta de usuarios registrados en caso de recibir parametro not null la consulta se hace por id*
*
* @return Array de usuarios registrados
* @param Int $datos id del usuario
*/
public function query_users($datos){
    if (is_null($datos)) {
        $consulta=$this->db->query("SELECT u.id_user as id,u.systems_name as usuario,u.user_name as name,status.status_name as status,status.status_color as color,profiles.profile_name as perfil,u.email_user as email FROM users as u INNER JOIN status ON (u.id_status=status.id_status) INNER JOIN profiles ON (u.id_profile=profiles.id_profile) ");
    }else{
        $consulta=$this->db->query("SELECT u.id_user as id,u.systems_name as usuario,u.user_name as name,u.id_status as status,u.id_profile as perfil,u.email_user as email FROM users as u WHERE u.id_user='$datos'");
    }
    while($filas=$consulta->fetch_assoc()){
        $this->query[]=$filas;
    }
    return $this->query;
}
/**
* Chequear si nombre de usuario existe.
*
*Funcion para chequear nombre de usuario existe*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de usuario,Int $id id del usuario
*/
public function check_name ($datos,$id){
    if (is_null($id)) {
        $consulta=$this->db->query("SELECT 1 FROM users WHERE systems_name='$datos' ");
    }else{
        $consulta=$this->db->query("SELECT 1 FROM users WHERE systems_name='$datos' AND id_user!='$id'");
    }
    $consulta2=$consulta->num_rows;
    if ($consulta2 > 0) {
        return false;
    }
    return true;
    
}
/**
* Chequear si usuario existe.
*
*Funcion para consultar id de usuarios registrado y asi evitar duplicidad ya que es un campo unico Si recibe parametro id not null es para indicar que ignore ese id en la consulta*
*
* @return Boolean false si existe true lo contrario 
* @param Int $datos id del usuario
*/
public function check_user ($datos){
    $consulta=$this->db->query("SELECT 1 FROM users WHERE id_user='$datos'");
    $consulta2=$consulta->num_rows;
    if ($consulta2 == 0) {
        return false;
    }
    return true;
}
/**
* Registrar usuarios.
*
*Funcion para registrar usuarios*
*
* @return Boolean  
* @param Array $empresas empresas del usuario,String $usuario nombre de usuario,String $nombre nombre del usuario,Int $user_code codigo de usuario,Int $type_doc tipo de documento,Int $doc numero de documento,String $clave del usuario
*/
public function register_user($perfil,$usuario,$nombre,$clave,$status,$email){
    $fecha=date('Y-m-d');
    $insert=$this->db->query("INSERT INTO users(systems_name,user_name,id_profile,id_status,user_pass,email_user) VALUES ('$usuario','$nombre','$perfil','$status','$clave','$email')");    
    return $insert;
}
/**
* Editar usuarios.
*
*Funcion para editar usuarios*
*
* @return Boolean  
* @param String $usuario nombre sistema,String $nombre nombre del usuario,Int $user_code codigo de usuario,Int $type_doc tipo de documento,Int $doc numero de documento,Int $status status del usuario,Array agregar_m empresas agregar,Array eliminar_m empresas eliminar,Int $id id del usuario
*/
public function edit_user($perfil,$usuario,$nombre,$status,$id,$email){
    $update=$this->db->query("UPDATE users SET systems_name='$usuario',user_name='$nombre',id_status='$status',id_profile='$perfil',email_user='$email' WHERE id_user='$id'");
    return $update;
}
/**
* Editar contraseña de usuario.
*
*Funcion para Editar contraseña de usuarios en caso de olvido*
*
* @return Boolean  
* @param String $clave clave nueva del usuario encriptada,String $clave_incial clave del usuario sin encriptar,Int $id id del usuario a modificar
*/
public function edit_password($clave,$id){
    $update=$this->db->query("UPDATE users SET user_pass='$clave' WHERE id_user='$id'");
    return $update;
}
/**
* Eliminar usuario.
*
*Funcion para eliminar usuario*
*
* @return Boolean  
* @param Int $id id del usuario
*/
public function delete_user($id){
    $delete=$this->db->query("DELETE FROM users WHERE id_user='$id'");
    return $delete;
}

/**
* Chequear si nombre de usuario existe.
*
*Funcion para chequear nombre de usuario existe*
*
* @return Boolean false si existe true lo contrario 
* @param String $datos nombre de usuario,Int $id id del usuario
*/
public function check_email ($datos,$id){
    $consulta1=$this->db->query("SELECT 1 FROM advisers WHERE email_adviser='$datos'"); 
    $consulta2=$this->db->query("SELECT 1 FROM agencies WHERE email_agency='$datos'"); 
    if (is_null($id)) {
    $consulta3=$this->db->query("SELECT 1 FROM users WHERE email_user='$datos'"); 
    }else{
    $consulta3=$this->db->query("SELECT 1 FROM users WHERE email_user='$datos' AND id_user !='$id' "); 
    }
    $count_consulta1=$consulta1->num_rows;
    $count_consulta2=$consulta2->num_rows;
    $count_consulta3=$consulta3->num_rows;
    if ($count_consulta1 > 0 || $count_consulta2 > 0 || $count_consulta3 > 0) {
        return false;
    }
    return true;
    
}



}
?>