<?php 
session_start();
require_once('includes/routencrypt.php');
$decryp=new routehelper();
header('Content-Type: application/json');
/**
* Procesador de solicitudes del sistema.
*
*Procesamiento de todas las solicitudes del sistema. 1.Desencriptacion la ruta, 2.Verifica que las variables de sesion sean correctas, 3.Valida permiso de acciones, 4.Valida token del sistema, 5.Carga de clases y controladores*
*
* @return Array [msg=> mensaje del error, status=> F = flase T = true, datos=> Array con datos devueltos]   
* @param POST String $option Ruta encriptada
*/
$solicitud = $_SERVER['REQUEST_METHOD'];
if(isset($_POST['option']) && !empty($_POST['option']) && $solicitud=="POST"){
$option = filter_input(INPUT_POST, 'option');
/**
* Desencriptacion la ruta.
*/
$option=$decryp->decryptroute($option);
/**
* Verifica que las variables de sesion sean correctas.
*/
$validacion=$decryp->validacion_adviser($_SESSION['bn_verify_global_advisers'],$_SESSION['bn_token_system_global_advisers'],$_SESSION['bn_user_global_advisers'],$_SESSION['bn_name_idsession']);
$option=explode('/',trim($option));
/**
* Valida token del sistema.
*/
$star=session_status() == PHP_SESSION_ACTIVE ? true : false;
if ($option[0] !== $_SESSION['bn_token_global_advisers'] || !$validacion) {
$datos = array('msg' => 'Error Sesion','status' => false);
header("HTTP/1.1 401", true);
print (json_encode($datos));
session_unset();
session_destroy();
exit();
}
/**
* Valida permiso de acciones.
*/

$validacion1=$decryp->validacion_module($_SESSION['bn_perfil'],$page);
if (!$validacion1) {
$datos = array('msg' => 'No tiene permiso para esta accion','status' => false);
header("HTTP/1.1 400", true);
print (json_encode($datos));
exit();
}

/**
* Carga de clases y controladores. En caso de de N no carga ninguna clase ya que solo es una consulta de acciones
*/
if ($option[2]==="N") {
print (json_encode(['status' => true,'msg' => 'Permiso concebido','datos' => '']));
}else{
/**
* Verifica si la opcion enviada tiene archivo existente
*/
$file='controller/'.$option[2].'_controller.php';
$metodo=$option[3];
$valid = (file_exists($file)) ? true:false;
if (!$valid) {
$array = array('msg' => 'Error Controller','status' => false,'code' => 400);
print (json_encode($array));
}else{
/**
* Incluye el archivo e invoca la clase
*/
$controller=$option[2]."_controller";
require_once($file);
$per=new $controller();
/**
* Valida si la funcion llamda existe
*/
$valid1=method_exists($per, $metodo);
$datos1 = array('msg' => 'Error method','status' => false,'code' => 400);
/**
* Carga de funcion en caso de que exista
*/
$datos=($valid1) ? $per->$metodo() : $datos1;
}
$code=(empty($datos['code']))? 200 : $datos['code'];
header("HTTP/1.1 $code", true);
print (json_encode($datos));
//print (json_encode(['status' => $datos['status'],'msg' => $datos['msg'],'datos' => $datos['datos']]));
}

}
?>